/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityIdEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmNonEntityIdPropertyEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContext;
import org.hibernate.search.mapper.pojo.identity.spi.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

abstract class AbstractHibernateOrmTypeContext<E>
implements HibernateOrmListenerTypeContext,
HibernateOrmSessionTypeContext<E>,
LoadingTypeContext<E> {
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final String jpaEntityName;
    private final EntityPersister entityPersister;
    private final boolean documentIdIsEntityId;
    private final HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy;
    private final IdentifierMapping identifierMapping;
    private final PojoPathFilter dirtyFilter;
    private final List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes;

    AbstractHibernateOrmTypeContext(AbstractBuilder<E> builder, SessionFactoryImplementor sessionFactory) {
        this.typeIdentifier = ((AbstractBuilder)builder).typeIdentifier;
        this.jpaEntityName = ((AbstractBuilder)builder).jpaEntityName;
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        this.entityPersister = metamodel.entityPersister(((AbstractBuilder)builder).hibernateOrmEntityName);
        this.identifierMapping = ((AbstractBuilder)builder).identifierMapping;
        this.ascendingSuperTypes = ((AbstractBuilder)builder).ascendingSuperTypes;
        if (((AbstractBuilder)builder).documentIdSourcePropertyName != null) {
            if (((AbstractBuilder)builder).documentIdSourcePropertyName.equals(this.entityPersister().getIdentifierPropertyName())) {
                this.documentIdIsEntityId = true;
                this.loadingStrategy = HibernateOrmEntityIdEntityLoadingStrategy.create(sessionFactory, this.entityPersister());
            } else {
                this.documentIdIsEntityId = false;
                this.loadingStrategy = HibernateOrmNonEntityIdPropertyEntityLoadingStrategy.create(sessionFactory, this.entityPersister(), ((AbstractBuilder)builder).documentIdSourcePropertyName, ((AbstractBuilder)builder).documentIdSourcePropertyHandle);
            }
        } else {
            this.documentIdIsEntityId = false;
            this.loadingStrategy = null;
        }
        this.dirtyFilter = ((AbstractBuilder)builder).dirtyFilter;
    }

    public String toString() {
        return this.typeIdentifier().toString();
    }

    @Override
    public PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public String jpaEntityName() {
        return this.jpaEntityName;
    }

    public String hibernateOrmEntityName() {
        return this.entityPersister.getEntityName();
    }

    @Override
    public EntityPersister entityPersister() {
        return this.entityPersister;
    }

    @Override
    public IdentifierMapping identifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public HibernateOrmEntityLoadingStrategy<? super E, ?> loadingStrategy() {
        return this.loadingStrategy;
    }

    @Override
    public List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes() {
        return this.ascendingSuperTypes;
    }

    @Override
    public Object toIndexingPlanProvidedId(Object entityId) {
        if (this.documentIdIsEntityId) {
            return entityId;
        }
        return null;
    }

    @Override
    public PojoPathFilter dirtyFilter() {
        return this.dirtyFilter;
    }

    static abstract class AbstractBuilder<E>
    implements PojoTypeExtendedMappingCollector {
        private final PojoRawTypeIdentifier<E> typeIdentifier;
        private final String jpaEntityName;
        private final String hibernateOrmEntityName;
        private String documentIdSourcePropertyName;
        private ValueReadHandle<?> documentIdSourcePropertyHandle;
        private IdentifierMapping identifierMapping;
        private PojoPathFilter dirtyFilter;
        private final List<PojoRawTypeIdentifier<? super E>> ascendingSuperTypes;

        AbstractBuilder(PojoRawTypeModel<E> typeModel, String jpaEntityName, String hibernateOrmEntityName) {
            this.typeIdentifier = typeModel.typeIdentifier();
            this.jpaEntityName = jpaEntityName;
            this.hibernateOrmEntityName = hibernateOrmEntityName;
            this.ascendingSuperTypes = typeModel.ascendingSuperTypes().map(PojoRawTypeModel::typeIdentifier).collect(Collectors.toList());
        }

        public void documentIdSourceProperty(PojoPropertyModel<?> documentIdSourceProperty) {
            this.documentIdSourcePropertyName = documentIdSourceProperty.name();
            this.documentIdSourcePropertyHandle = documentIdSourceProperty.handle();
        }

        public void identifierMapping(IdentifierMapping identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        public void dirtyFilter(PojoPathFilter dirtyFilter) {
            this.dirtyFilter = dirtyFilter;
        }
    }
}

