package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import org.hibernate.SessionFactory;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.ScrollMode;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.mapping.Value;
import java.lang.Throwable;
import java.util.Collection;
import java.util.List;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String versionString) {
        super.log.logf(FQCN, INFO, null, version$str(), versionString);
    }
    protected String version$str() {
        return "HSEARCH000034: Hibernate Search version %1$s";
    }
    @Override
    public final void cannotGuessTransactionStatus(final Exception e) {
        super.log.logf(FQCN, WARN, e, cannotGuessTransactionStatus$str());
    }
    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Unable to guess the transaction status: not starting a JTA transaction.";
    }
    @Override
    public final void unableToCloseSearcherInScrollableResult(final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCloseSearcherInScrollableResult$str());
    }
    protected String unableToCloseSearcherInScrollableResult$str() {
        return "HSEARCH000039: Unable to properly close scroll in ScrollableResults.";
    }
    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction active. Consider increasing the connection time-out.";
    }
    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionNotActiveWhileProducingIdsForBatchIndexing$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }
    @Override
    public final SearchException hibernateSearchNotInitialized() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSearchNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.";
    }
    @Override
    public final SearchException unknownPathForDirtyChecking(final PojoModelPath path, final Exception e) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownPathForDirtyChecking$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path)), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }
    @Override
    public final SearchException unreportedPathForDirtyChecking(final PojoModelPath path, final Value value) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unreportedPathForDirtyChecking$str(), new org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter(path), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.";
    }
    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(final Class<?> ormMappingClass, final String extractorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }
    @Override
    public final SearchException usingDifferentSessionFactories(final SessionFactory expectedSessionFactory, final SessionFactory usedSessionFactory) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Unable to retrieve property type model for '%1$s' on '%2$s': %3$s";
    }
    @Override
    public final SearchException errorRetrievingPropertyTypeModel(final String propertyModelName, final PojoRawTypeModel<?> parentTypeModel, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), errorRetrievingPropertyTypeModel$str(), propertyModelName, new org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter(parentTypeModel), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Unable to access Hibernate ORM session: %1$s";
    }
    @Override
    public final SearchException hibernateSessionAccessError(final String causeMessage, final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionAccessError$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session is closed.";
    }
    @Override
    public final SearchException hibernateSessionIsClosed(final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionIsClosed$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(final String entityName, final EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        super.log.logf(FQCN, DEBUG, null, skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), entityName, cacheLookupStrategy);
    }
    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }
    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(final String entityName) {
        super.log.logf(FQCN, DEBUG, null, skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), entityName);
    }
    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.";
    }
    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Unable to access Hibernate ORM session factory: %1$s";
    }
    @Override
    public final SearchException hibernateSessionFactoryAccessError(final String causeMessage, final IllegalStateException cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), hibernateSessionFactoryAccessError$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }
    @Override
    public final SearchException indexingFailure(final String causeMessage, final List<org.hibernate.search.mapper.orm.common.EntityReference> failingEntities, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexingFailure$str(), causeMessage, failingEntities), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String automaticIndexing$str() {
        return "Automatic indexing of Hibernate ORM entities";
    }
    @Override
    public final String automaticIndexing() {
        return String.format(getLoggingLocale(), automaticIndexing$str());
    }
    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Unable to process entities for automatic indexing before transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationBeforeTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Unable to index documents for automatic indexing after transaction completion: %1$s";
    }
    @Override
    public final SearchException synchronizationAfterTransactionFailure(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionHandlingException$str() {
        return "HSEARCH800025: Unable to handle transaction: %1$s";
    }
    @Override
    public final SearchException transactionHandlingException(final String causeMessage, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), transactionHandlingException$str(), causeMessage), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }
    @Override
    public final SearchException unknownNamedType(final String typeName, final Collection<String> availableNamedTypes) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unknownNamedType$str(), typeName, availableNamedTypes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntityName$str() {
        return "HSEARCH800028: Unknown entity name: '%1$s'. Available entity names: %2$s.";
    }
    @Override
    public final SearchException invalidEntityName(final String entityName, final Collection<String> availableEntityNames) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntityName$str(), entityName, availableEntityNames));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEntitySuperType$str() {
        return "HSEARCH800029: Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.";
    }
    @Override
    public final SearchException invalidEntitySuperType(final String entityName, final Class<?> expectedSuperType, final Class<?> actualJavaType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidEntitySuperType$str(), entityName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualJavaType)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH800032: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }
    @Override
    public final SearchException invalidSchemaManagementStrategyName(final String invalidRepresentation, final List<String> validRepresentations) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notIndexedEntityType$str() {
        return "HSEARCH800033: Type '%1$s' is not an entity type, or this entity type is not indexed.";
    }
    @Override
    public final SearchException notIndexedEntityType(final Class<?> type) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedEntityType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notIndexedEntityName$str() {
        return "HSEARCH800034: Entity type '%1$s' is not indexed.";
    }
    @Override
    public final SearchException notIndexedEntityName(final String name) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notIndexedEntityName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void shutdownFailed(final String causeMessage, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, shutdownFailed$str(), causeMessage);
    }
    protected String shutdownFailed$str() {
        return "HSEARCH800035: Unable to shut down Hibernate Search: %1$s";
    }
    protected String canOnlyUseScrollWithScrollModeForwardsOnly$str() {
        return "HSEARCH800036: Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.";
    }
    @Override
    public final SearchException canOnlyUseScrollWithScrollModeForwardsOnly(final ScrollMode scrollMode) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), canOnlyUseScrollWithScrollModeForwardsOnly$str(), scrollMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotScrollBackwards$str() {
        return "HSEARCH800037: Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.";
    }
    @Override
    public final SearchException cannotScrollBackwards() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotScrollBackwards$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSetScrollPositionRelativeToEnd$str() {
        return "HSEARCH800038: Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().";
    }
    @Override
    public final SearchException cannotSetScrollPositionRelativeToEnd() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotSetScrollPositionRelativeToEnd$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseClosedScrollableResults$str() {
        return "HSEARCH800039: Cannot use this ScrollableResults instance: it is closed.";
    }
    @Override
    public final SearchException cannotUseClosedScrollableResults() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotUseClosedScrollableResults$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String foundMultipleEntitiesForDocumentId$str() {
        return "HSEARCH800040: Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.";
    }
    @Override
    public final SearchException foundMultipleEntitiesForDocumentId(final String entityName, final String documentIdSourcePropertyName, final Object id) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), foundMultipleEntitiesForDocumentId$str(), entityName, documentIdSourcePropertyName, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanNotFoundInBeanContainer$str() {
        return "HSEARCH800041: No such bean in bean container '%1$s'.";
    }
    @Override
    public final BeanNotFoundException beanNotFoundInBeanContainer(final BeanContainer beanContainer) {
        final BeanNotFoundException result = new BeanNotFoundException(String.format(getLoggingLocale(), beanNotFoundInBeanContainer$str(), beanContainer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str() {
        return "HSEARCH800042: Cannot customize the synchronization strategy:  the selected automatic indexing strategy always processes events asynchronously, through a queue.";
    }
    @Override
    public final SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void automaticIndexingStrategyIsDeprecated(final String resolveOrRaw, final String resolveOrRaw1) {
        super.log.logf(FQCN, WARN, null, automaticIndexingStrategyIsDeprecated$str(), resolveOrRaw, resolveOrRaw1);
    }
    protected String automaticIndexingStrategyIsDeprecated$str() {
        return "HSEARCH800053: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }
    protected String missingTenantIdConfiguration$str() {
        return "HSEARCH800054: Cannot determine the set of all possible tenant identifiers. You must provide this information by setting configuration property '%1$s' to a comma-separated string containing all possible tenant identifiers.";
    }
    @Override
    public final SearchException missingTenantIdConfiguration(final String tenantIdsConfigurationPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingTenantIdConfiguration$str(), tenantIdsConfigurationPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTenantId$str() {
        return "HSEARCH800055: Cannot target tenant '%1$s' because this tenant identifier was not listed in the configuration provided on startup. To target this tenant, you must provide the tenant identifier through configuration property '%3$s', which should be set to a comma-separated string containing all possible tenant identifiers. Currently configured tenant identifiers: %2$s.";
    }
    @Override
    public final SearchException invalidTenantId(final String tenantId, final Set<String> allTenantIds, final String tenantIdsConfigurationPropertyKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidTenantId$str(), tenantId, allTenantIds, tenantIdsConfigurationPropertyKey));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
