/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.coordination.common.spi.CooordinationStrategy;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingConfigurationContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapperDelegate;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMetatadaContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.session.impl.ConfiguredAutomaticIndexingStrategy;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMappingPartialBuildState>
implements HibernateOrmMappingConfigurationContext {
    private static final ConfigurationProperty<Boolean> MAPPING_PROCESS_ANNOTATIONS = ConfigurationProperty.forKey((String)"mapping.process_annotations").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends HibernateOrmSearchMappingConfigurer>> MAPPING_CONFIGURER = ConfigurationProperty.forKey((String)"mapping.configurer").asBeanReference(HibernateOrmSearchMappingConfigurer.class).build();
    private static final ConfigurationProperty<BeanReference<? extends CooordinationStrategy>> COORDINATION_STRATEGY = ConfigurationProperty.forKey((String)"coordination.strategy").asBeanReference(CooordinationStrategy.class).withDefault(HibernateOrmMapperSettings.Defaults.COORDINATION_STRATEGY).build();
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final HibernateOrmBootstrapIntrospector introspector;
    private BeanHolder<? extends CooordinationStrategy> coordinationStrategyHolder;
    private ConfiguredAutomaticIndexingStrategy configuredAutomaticIndexingStrategy;

    public static HibernateOrmMappingInitiator create(Metadata metadata, ReflectionManager reflectionManager, ValueReadHandleFactory valueReadHandleFactory, ConfigurationService ormConfigurationService) {
        HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider = HibernateOrmBasicTypeMetadataProvider.create(metadata);
        HibernateOrmBootstrapIntrospector introspector = HibernateOrmBootstrapIntrospector.create(basicTypeMetadataProvider, reflectionManager, valueReadHandleFactory);
        return new HibernateOrmMappingInitiator(basicTypeMetadataProvider, introspector, ormConfigurationService);
    }

    private HibernateOrmMappingInitiator(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, HibernateOrmBootstrapIntrospector introspector, ConfigurationService ormConfigurationService) {
        super((PojoBootstrapIntrospector)introspector);
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.introspector = introspector;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)ormConfigurationService.getSettings());
        this.multiTenancyEnabled(!MultiTenancyStrategy.NONE.equals((Object)multiTenancyStrategy));
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.push(ConfiguredAutomaticIndexingStrategy::stop, (Object)this.configuredAutomaticIndexingStrategy);
            closer.push(CooordinationStrategy::stop, this.coordinationStrategyHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.coordinationStrategyHolder);
        }
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        BeanResolver beanResolver = buildContext.beanResolver();
        ConfigurationPropertySource propertySource = buildContext.configurationPropertySource();
        this.addConfigurationContributor(new HibernateOrmMetatadaContributor(this.basicTypeMetadataProvider, this.introspector));
        ConfiguredAutomaticIndexingStrategy.Builder builder = new ConfiguredAutomaticIndexingStrategy.Builder();
        this.coordinationStrategyHolder = (BeanHolder)COORDINATION_STRATEGY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        ((CooordinationStrategy)this.coordinationStrategyHolder.get()).configureAutomaticIndexing(builder);
        this.configuredAutomaticIndexingStrategy = builder.build();
        this.containedEntityIdentityMappingRequired(this.configuredAutomaticIndexingStrategy.usesEventQueue());
        boolean processAnnotations = (Boolean)MAPPING_PROCESS_ANNOTATIONS.get(propertySource);
        if (processAnnotations) {
            this.annotatedTypeDiscoveryEnabled(true);
            AnnotationMappingConfigurationContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass : this.basicTypeMetadataProvider.getPersistentClasses()) {
                if (!persistentClass.hasPojoRepresentation()) continue;
                annotationMapping.add(persistentClass.getMappedClass());
            }
        }
        MAPPING_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
            try (BeanHolder configurerHolder = holder;){
                ((HibernateOrmSearchMappingConfigurer)configurerHolder.get()).configure(this);
            }
        });
        super.configure(buildContext, configurationCollector);
    }

    protected PojoMapperDelegate<HibernateOrmMappingPartialBuildState> createMapperDelegate() {
        return new HibernateOrmMapperDelegate(this.basicTypeMetadataProvider, this.coordinationStrategyHolder, this.configuredAutomaticIndexingStrategy);
    }
}

