/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.persistence.OptimisticLockException;
import org.hibernate.ScrollMode;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return "HSEARCH000034: Hibernate Search version %1$s";
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Unable to guess the transaction status: not starting a JTA transaction.";
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return "HSEARCH000039: Unable to properly close scroll in ScrollableResults.";
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction active. Consider increasing the connection time-out.";
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Unable to resolve path '%1$s' to a persisted attribute in Hibernate ORM metadata. If this path points to a transient attribute, use @IndexingDependency(derivedFrom = ...) to specify which persisted attributes it is derived from. See the reference documentation for more information.";
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), new PojoModelPathFormatter(path)), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' points to attribute '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), new PojoModelPathFormatter(path), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Unable to apply container value extractor with name '%2$s' to Hibernate ORM metadata node of type '%1$s'.";
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Unable to create a SearchSession for sessions created using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Unable to retrieve property type model for '%1$s' on '%2$s': %3$s";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Unable to access Hibernate ORM session: %1$s";
    }

    @Override
    public final SearchException hibernateSessionAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session is closed.";
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String entityName, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)entityName, (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' is ignoring the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)entityName);
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' is ignoring the second-level cache even though it was instructed to use it, because caching is not enabled for this entity type.";
    }

    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Unable to access Hibernate ORM session factory: %1$s";
    }

    @Override
    public final SearchException hibernateSessionFactoryAccessError(String causeMessage, IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionFactoryAccessError$str(), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }

    @Override
    public final SearchException indexingFailure(String causeMessage, List<EntityReference> failingEntities, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexingFailure$str(), causeMessage, failingEntities), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String automaticIndexing$str() {
        return "Automatic indexing of Hibernate ORM entities";
    }

    @Override
    public final String automaticIndexing() {
        return String.format(this.getLoggingLocale(), this.automaticIndexing$str(), new Object[0]);
    }

    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Unable to process entities for automatic indexing before transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationBeforeTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Unable to index documents for automatic indexing after transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationAfterTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String transactionHandlingException$str() {
        return "HSEARCH800025: Unable to handle transaction: %1$s";
    }

    @Override
    public final SearchException transactionHandlingException(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionHandlingException$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }

    @Override
    public final SearchException unknownNamedType(String typeName, Collection<String> availableNamedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNamedType$str(), typeName, availableNamedTypes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEntityName$str() {
        return "HSEARCH800028: Unknown entity name: '%1$s'. Available entity names: %2$s.";
    }

    @Override
    public final SearchException invalidEntityName(String entityName, Collection<String> availableEntityNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntityName$str(), entityName, availableEntityNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidEntitySuperType$str() {
        return "HSEARCH800029: Invalid type for '%1$s': the entity type must extend '%2$s', but entity type '%3$s' does not.";
    }

    @Override
    public final SearchException invalidEntitySuperType(String entityName, Class<?> expectedSuperType, Class<?> actualJavaType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntitySuperType$str(), entityName, new ClassFormatter(expectedSuperType), new ClassFormatter(actualJavaType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidSchemaManagementStrategyName$str() {
        return "HSEARCH800032: Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidSchemaManagementStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidSchemaManagementStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notIndexedEntityType$str() {
        return "HSEARCH800033: Type '%1$s' is not an entity type, or this entity type is not indexed.";
    }

    @Override
    public final SearchException notIndexedEntityType(Class<?> type) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notIndexedEntityType$str(), new ClassFormatter(type)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notIndexedEntityName$str() {
        return "HSEARCH800034: Entity type '%1$s' is not indexed.";
    }

    @Override
    public final SearchException notIndexedEntityName(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notIndexedEntityName$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void shutdownFailed(String causeMessage, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.shutdownFailed$str(), (Object)causeMessage);
    }

    protected String shutdownFailed$str() {
        return "HSEARCH800035: Unable to shut down Hibernate Search: %1$s";
    }

    protected String canOnlyUseScrollWithScrollModeForwardsOnly$str() {
        return "HSEARCH800036: Cannot use scroll() with scroll mode '%1$s' with Hibernate Search queries: only ScrollMode.FORWARDS_ONLY is supported.";
    }

    @Override
    public final SearchException canOnlyUseScrollWithScrollModeForwardsOnly(ScrollMode scrollMode) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.canOnlyUseScrollWithScrollModeForwardsOnly$str(), scrollMode));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotScrollBackwards$str() {
        return "HSEARCH800037: Cannot scroll backwards with Hibernate Search scrolls: they are forwards-only. Ensure you always increment the scroll position, and never decrement it.";
    }

    @Override
    public final SearchException cannotScrollBackwards() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotScrollBackwards$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSetScrollPositionRelativeToEnd$str() {
        return "HSEARCH800038: Cannot set the scroll position relative to the end with Hibernate Search scrolls. Ensure you always pass a positive number to setRowNumber().";
    }

    @Override
    public final SearchException cannotSetScrollPositionRelativeToEnd() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotSetScrollPositionRelativeToEnd$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseClosedScrollableResults$str() {
        return "HSEARCH800039: Cannot use this ScrollableResults instance: it is closed.";
    }

    @Override
    public final SearchException cannotUseClosedScrollableResults() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseClosedScrollableResults$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String foundMultipleEntitiesForDocumentId$str() {
        return "HSEARCH800040: Multiple instances of entity type '%1$s' have their property '%2$s' set to '%3$s'. '%2$s' is the document ID and must be assigned unique values.";
    }

    @Override
    public final SearchException foundMultipleEntitiesForDocumentId(String entityName, String documentIdSourcePropertyName, Object id) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.foundMultipleEntitiesForDocumentId$str(), entityName, documentIdSourcePropertyName, id));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanNotFoundInBeanContainer$str() {
        return "HSEARCH800041: No such bean in bean container '%1$s'.";
    }

    @Override
    public final BeanNotFoundException beanNotFoundInBeanContainer(BeanContainer beanContainer) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.beanNotFoundInBeanContainer$str(), beanContainer));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str() {
        return "HSEARCH800042: Cannot customize the synchronization strategy:  the selected automatic indexing strategy always processes events asynchronously, through a queue.";
    }

    @Override
    public final SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotConfigureSynchronizationStrategyWithIndexingEventQueue$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void outboxGeneratedEntityMapping(String xmlMappingDefinition) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.outboxGeneratedEntityMapping$str(), (Object)xmlMappingDefinition);
    }

    protected String outboxGeneratedEntityMapping$str() {
        return "HSEARCH800043: Outbox-generated entity mapping: %1$s";
    }

    @Override
    public final void sessionFactoryIsClosedOnOutboxProcessing() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.sessionFactoryIsClosedOnOutboxProcessing$str(), new Object[0]);
    }

    protected String sessionFactoryIsClosedOnOutboxProcessing$str() {
        return "HSEARCH800044: Session factory closed while processing outbox events. Assuming Hibernate Search is shutting down.";
    }

    protected String maxRetryExhausted$str() {
        return "HSEARCH800045: Max '%1$s' retries exhausted to process the event. Event will be lost.";
    }

    @Override
    public final SearchException maxRetryExhausted(int retries) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.maxRetryExhausted$str(), retries));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void automaticIndexingRetry(Long eventId, String entityName, String entityId, int attempts) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.automaticIndexingRetry$str(), new Object[]{eventId, entityName, entityId, attempts});
    }

    protected String automaticIndexingRetry$str() {
        return "HSEARCH800046: Automatic indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Will try again soon. Attempts so far: %4$d.";
    }

    @Override
    public final void startingOutboxEventProcessor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingOutboxEventProcessor$str(), (Object)name);
    }

    protected String startingOutboxEventProcessor$str() {
        return "HSEARCH800047: Starting outbox event processor '%1$s'";
    }

    @Override
    public final void stoppingOutboxEventProcessor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingOutboxEventProcessor$str(), (Object)name);
    }

    protected String stoppingOutboxEventProcessor$str() {
        return "HSEARCH800048: Stopping outbox event processor '%1$s'";
    }

    protected String invalidTotalShardCount$str() {
        return "HSEARCH800049: The total shard count must be strictly positive.";
    }

    @Override
    public final SearchException invalidTotalShardCount() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTotalShardCount$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidShardIndex$str() {
        return "HSEARCH800050: Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').";
    }

    @Override
    public final SearchException invalidShardIndex(int totalShardCount, String totalShardCountPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidShardIndex$str(), totalShardCount, totalShardCountPropertyKey));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPropertyForStaticSharding$str() {
        return "HSEARCH800051: When using static sharding, this property must be set.";
    }

    @Override
    public final SearchException missingPropertyForStaticSharding() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyForStaticSharding$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void indexingProcessorDisabled() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.indexingProcessorDisabled$str(), new Object[0]);
    }

    protected String indexingProcessorDisabled$str() {
        return "HSEARCH800052: The indexing processor is disabled.  Events will accumulate in the queue and indexes will not be updated, unless another application node connects to the same database with their indexing processor enabled.";
    }

    @Override
    public final void automaticIndexingStrategyIsDeprecated(String resolveOrRaw, String resolveOrRaw1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.automaticIndexingStrategyIsDeprecated$str(), (Object)resolveOrRaw, (Object)resolveOrRaw1);
    }

    protected String automaticIndexingStrategyIsDeprecated$str() {
        return "HSEARCH800053: Configuration property '%1$s' is deprecated; use '%2$s' instead.";
    }

    @Override
    public final void outboxEventProcessorUnableToLock(String name, OptimisticLockException lockException) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)lockException, this.outboxEventProcessorUnableToLock$str(), (Object)name);
    }

    protected String outboxEventProcessorUnableToLock$str() {
        return "HSEARCH800054: '%1$s' failed to obtain a lock on events to process; will try again later.";
    }
}

