/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.coordination.databasepolling.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.orm.coordination.databasepolling.impl.OutboxEventPredicate;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

class EntityIdHashRangeOutboxEventPredicate
implements OutboxEventPredicate {
    private static final String LOWER_BOUND_PARAM_NAME = "lowerHash";
    private static final String UPPER_BOUND_PARAM_NAME = "upperHash";
    private final Range<Integer> range;

    public EntityIdHashRangeOutboxEventPredicate(Range<Integer> range) {
        this.range = range;
    }

    @Override
    public String queryPart(String eventAlias) {
        RangeBoundInclusion upperBoundCondition;
        StringBuilder builder = new StringBuilder(eventAlias);
        builder.append(".entityIdHash ");
        RangeBoundInclusion lowerBoundCondition = this.range.lowerBoundValue().isPresent() ? this.range.lowerBoundInclusion() : null;
        RangeBoundInclusion rangeBoundInclusion = upperBoundCondition = this.range.upperBoundValue().isPresent() ? this.range.upperBoundInclusion() : null;
        if (lowerBoundCondition == RangeBoundInclusion.INCLUDED && upperBoundCondition == RangeBoundInclusion.INCLUDED) {
            builder.append("between :").append(LOWER_BOUND_PARAM_NAME).append(" and :").append(UPPER_BOUND_PARAM_NAME);
        } else {
            if (lowerBoundCondition == RangeBoundInclusion.INCLUDED) {
                builder.append(" >= :").append(LOWER_BOUND_PARAM_NAME);
            } else if (lowerBoundCondition == RangeBoundInclusion.EXCLUDED) {
                builder.append(" > :").append(LOWER_BOUND_PARAM_NAME);
            }
            if (lowerBoundCondition != null && upperBoundCondition != null) {
                builder.append(" and ").append(eventAlias).append(".entityIdHash ");
            }
            if (upperBoundCondition == RangeBoundInclusion.INCLUDED) {
                builder.append(" <= :").append(UPPER_BOUND_PARAM_NAME);
            } else if (upperBoundCondition == RangeBoundInclusion.EXCLUDED) {
                builder.append(" < :").append(UPPER_BOUND_PARAM_NAME);
            }
        }
        return builder.toString();
    }

    @Override
    public Map<String, Object> params() {
        Optional upperBound;
        HashMap<String, Object> params = new HashMap<String, Object>();
        Optional lowerBound = this.range.lowerBoundValue();
        if (lowerBound.isPresent()) {
            params.put(LOWER_BOUND_PARAM_NAME, lowerBound.get());
        }
        if ((upperBound = this.range.upperBoundValue()).isPresent()) {
            params.put(UPPER_BOUND_PARAM_NAME, upperBound.get());
        }
        return params;
    }
}

