/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private HibernateOrmUtils() {
    }

    public static SessionFactoryImplementor toSessionFactoryImplementor(EntityManagerFactory entityManagerFactory) {
        try {
            return (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionFactoryAccessError(e.getMessage(), e);
        }
    }

    public static Session toSession(EntityManager entityManager) {
        try {
            return (Session)entityManager.unwrap(Session.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e.getMessage(), e);
        }
    }

    public static SessionImplementor toSessionImplementor(EntityManager entityManager) {
        try {
            return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e.getMessage(), e);
        }
    }

    private static boolean isSuperTypeOf(EntityPersister type1, EntityPersister type2) {
        return type1.isSubclassEntityName(type2.getEntityName());
    }

    public static EntityPersister toRootEntityType(SessionFactoryImplementor sessionFactory, EntityPersister entityType) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        String rootEntityName = entityType.getRootEntityName();
        return metamodel.entityPersister(rootEntityName);
    }

    public static EntityPersister toMostSpecificCommonEntitySuperType(MetamodelImplementor metamodel, EntityPersister type1, EntityPersister type2) {
        EntityPersister superTypeCandidate = type1;
        while (superTypeCandidate != null && !HibernateOrmUtils.isSuperTypeOf(superTypeCandidate, type2)) {
            String superSuperTypeEntityName = superTypeCandidate.getEntityMetamodel().getSuperclass();
            superTypeCandidate = superSuperTypeEntityName == null ? null : metamodel.entityPersister(superSuperTypeEntityName).getEntityPersister();
        }
        if (superTypeCandidate == null) {
            throw new AssertionFailure("Cannot find a common entity supertype for " + type1.getEntityName() + " and " + type2.getEntityName() + ". There is a bug in Hibernate Search, please report it.");
        }
        return superTypeCandidate;
    }

    public static boolean hasAtMostOneConcreteSubType(SessionFactoryImplementor sessionFactory, EntityPersister parentType) {
        Set subClassEntityNames = parentType.getEntityMetamodel().getSubclassEntityNames();
        if (subClassEntityNames.size() == 1) {
            return true;
        }
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        int concreteSubTypesCount = 0;
        for (String subClassEntityName : subClassEntityNames) {
            if (metamodel.entityPersister(subClassEntityName).getEntityMetamodel().isAbstract() || ++concreteSubTypesCount <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean targetsAllConcreteSubTypes(SessionFactoryImplementor sessionFactory, EntityPersister parentType, Collection<?> targetConcreteSubTypes) {
        Set subClassEntityNames = parentType.getEntityMetamodel().getSubclassEntityNames();
        if (subClassEntityNames.size() == targetConcreteSubTypes.size()) {
            return true;
        }
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        int concreteSubTypesCount = 0;
        for (String subClassEntityName : subClassEntityNames) {
            if (metamodel.entityPersister(subClassEntityName).getEntityMetamodel().isAbstract()) continue;
            ++concreteSubTypesCount;
        }
        return concreteSubTypesCount == targetConcreteSubTypes.size();
    }
}

