/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.cfg;

import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.coordination.common.spi.CooordinationStrategy;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;

public final class HibernateOrmMapperSettings {
    public static final String PREFIX = "hibernate.search.";
    public static final String ENABLED = "hibernate.search.enabled";
    public static final String AUTOMATIC_INDEXING_ENABLED = "hibernate.search.automatic_indexing.enabled";
    @Deprecated
    public static final String AUTOMATIC_INDEXING_STRATEGY = "hibernate.search.automatic_indexing.strategy";
    public static final String AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = "hibernate.search.automatic_indexing.synchronization.strategy";
    public static final String AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = "hibernate.search.automatic_indexing.enable_dirty_check";
    public static final String QUERY_LOADING_CACHE_LOOKUP_STRATEGY = "hibernate.search.query.loading.cache_lookup.strategy";
    public static final String QUERY_LOADING_FETCH_SIZE = "hibernate.search.query.loading.fetch_size";
    public static final String MAPPING_PROCESS_ANNOTATIONS = "hibernate.search.mapping.process_annotations";
    public static final String MAPPING_CONFIGURER = "hibernate.search.mapping.configurer";
    public static final String SCHEMA_MANAGEMENT_STRATEGY = "hibernate.search.schema_management.strategy";
    public static final String COORDINATION_STRATEGY = "hibernate.search.coordination.strategy";
    public static final String COORDINATION_SHARDS_STATIC = "hibernate.search.coordination.shards.static";
    public static final String COORDINATION_SHARDS_TOTAL_COUNT = "hibernate.search.coordination.shards.total_count";
    public static final String COORDINATION_SHARDS_ASSIGNED = "hibernate.search.coordination.shards.assigned";
    public static final String COORDINATION_PROCESSORS_INDEXING_ENABLED = "hibernate.search.coordination.processors.indexing.enabled";
    public static final String COORDINATION_PROCESSORS_INDEXING_POLLING_INTERVAL = "hibernate.search.coordination.processors.indexing.polling_interval";
    public static final String COORDINATION_PROCESSORS_INDEXING_BATCH_SIZE = "hibernate.search.coordination.processors.indexing.batch_size";

    private HibernateOrmMapperSettings() {
    }

    public static final class Defaults {
        public static final boolean ENABLED = true;
        public static final boolean AUTOMATIC_INDEXING_ENABLED = true;
        @Deprecated
        public static final AutomaticIndexingStrategyName AUTOMATIC_INDEXING_STRATEGY = AutomaticIndexingStrategyName.SESSION;
        public static final BeanReference<AutomaticIndexingSynchronizationStrategy> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = BeanReference.of(AutomaticIndexingSynchronizationStrategy.class, (String)"write-sync");
        public static final boolean AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = true;
        public static final EntityLoadingCacheLookupStrategy QUERY_LOADING_CACHE_LOOKUP_STRATEGY = EntityLoadingCacheLookupStrategy.SKIP;
        public static final int QUERY_LOADING_FETCH_SIZE = 100;
        public static final boolean MAPPING_PROCESS_ANNOTATIONS = true;
        public static final SchemaManagementStrategyName SCHEMA_MANAGEMENT_STRATEGY = SchemaManagementStrategyName.CREATE_OR_VALIDATE;
        public static final BeanReference<CooordinationStrategy> COORDINATION_STRATEGY = BeanReference.of(CooordinationStrategy.class, (String)"none");
        public static final boolean COORDINATION_SHARDS_STATIC = false;
        public static final boolean COORDINATION_PROCESSORS_INDEXING_ENABLED = true;
        public static final int COORDINATION_PROCESSORS_INDEXING_POLLING_INTERVAL = 100;
        public static final int COORDINATION_PROCESSORS_INDEXING_BATCH_SIZE = 50;

        private Defaults() {
        }
    }

    public static final class CoordinationRadicals {
        public static final String STRATEGY = "strategy";
        public static final String SHARDS_STATIC = "shards.static";
        public static final String SHARDS_TOTAL_COUNT = "shards.total_count";
        public static final String SHARDS_ASSIGNED = "shards.assigned";
        public static final String PROCESSORS_PREFIX = "processors.";
        public static final String PROCESSORS_INDEXING_PREFIX = "processors.indexing.";
        public static final String PROCESSORS_INDEXING_ENABLED = "processors.indexing.enabled";
        public static final String PROCESSORS_INDEXING_POLLING_INTERVAL = "processors.indexing.polling_interval";
        public static final String PROCESSORS_INDEXING_BATCH_SIZE = "processors.indexing.batch_size";

        private CoordinationRadicals() {
        }
    }

    public static final class AutomaticIndexingRadicals {
        public static final String ENABLED = "enabled";
        @Deprecated
        public static final String STRATEGY = "strategy";
        public static final String SYNCHRONIZATION_STRATEGY = "synchronization.strategy";
        public static final String ENABLE_DIRTY_CHECK = "enable_dirty_check";

        private AutomaticIndexingRadicals() {
        }
    }

    public static final class Radicals {
        public static final String ENABLED = "enabled";
        public static final String AUTOMATIC_INDEXING = "automatic_indexing";
        public static final String AUTOMATIC_INDEXING_PREFIX = "automatic_indexing.";
        public static final String AUTOMATIC_INDEXING_ENABLED = "automatic_indexing.enabled";
        @Deprecated
        public static final String AUTOMATIC_INDEXING_STRATEGY = "automatic_indexing.strategy";
        public static final String AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = "automatic_indexing.synchronization.strategy";
        public static final String AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = "automatic_indexing.enable_dirty_check";
        public static final String QUERY_LOADING_CACHE_LOOKUP_STRATEGY = "query.loading.cache_lookup.strategy";
        public static final String QUERY_LOADING_FETCH_SIZE = "query.loading.fetch_size";
        public static final String MAPPING_PROCESS_ANNOTATIONS = "mapping.process_annotations";
        public static final String MAPPING_CONFIGURER = "mapping.configurer";
        public static final String SCHEMA_MANAGEMENT_STRATEGY = "schema_management.strategy";
        public static final String COORDINATION = "coordination";
        public static final String COORDINATION_PREFIX = "coordination.";
        public static final String COORDINATION_STRATEGY = "coordination.strategy";
        public static final String COORDINATION_SHARDS_STATIC = "coordination.shards.static";
        public static final String COORDINATION_SHARDS_TOTAL_COUNT = "coordination.shards.total_count";
        public static final String COORDINATION_SHARDS_ASSIGNED = "coordination.shards.assigned";
        public static final String COORDINATION_PROCESSORS_INDEXING_ENABLED = "coordination.processors.indexing.enabled";
        public static final String COORDINATION_PROCESSORS_INDEXING_POLLING_INTERVAL = "coordination.processors.indexing.polling_interval";
        public static final String COORDINATION_PROCESSORS_INDEXING_BATCH_SIZE = "coordination.processors.indexing.batch_size";

        private Radicals() {
        }
    }
}

