/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingEntityFailureContext;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingFailureContext;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingSessionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MassIndexingNotifier {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MassIndexingFailureHandler failureHandler;
    private final MassIndexingMonitor monitor;
    private final AtomicReference<RecordedFailure> firstFailure = new AtomicReference<Object>(null);
    private final LongAdder failureCount = new LongAdder();

    MassIndexingNotifier(MassIndexingFailureHandler failureHandler, MassIndexingMonitor monitor) {
        this.failureHandler = failureHandler;
        this.monitor = monitor;
    }

    void reportAddedTotalCount(long totalCount) {
        this.monitor.addToTotalCount(totalCount);
    }

    void reportError(Error error) {
        RecordedFailure recordedFailure = new RecordedFailure(error);
        this.firstFailure.compareAndSet(null, recordedFailure);
    }

    void reportInterrupted(InterruptedException exception) {
        RecordedFailure recordedFailure = new RecordedFailure(exception);
        boolean isFirst = this.firstFailure.compareAndSet(null, recordedFailure);
        if (isFirst) {
            log.interruptedBatchIndexing();
        }
    }

    void reportRunnableFailure(Exception exception, String operation) {
        this.recordFailure(exception, true);
        MassIndexingFailureContext.Builder contextBuilder = MassIndexingFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(operation);
        this.failureHandler.handle(contextBuilder.build());
    }

    void reportEntitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    void reportDocumentBuilt() {
        this.monitor.documentsBuilt(1L);
    }

    void reportDocumentsAdded(int size) {
        this.monitor.documentsAdded(size);
    }

    <T> void reportEntityIndexingFailure(HibernateOrmMassIndexingIndexedTypeContext<T> type, HibernateOrmMassIndexingSessionContext sessionContext, T entity, Exception exception) {
        RecordedFailure recordedFailure = this.recordFailure(exception, false);
        MassIndexingEntityFailureContext.Builder contextBuilder = MassIndexingEntityFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(log.massIndexerIndexingInstance(type.jpaEntityName()));
        EntityReference entityReference = this.extractReferenceOrSuppress(type, sessionContext, entity, exception);
        if (entityReference != null) {
            contextBuilder.entityReference(entityReference);
            recordedFailure.entityReference = entityReference;
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    void reportIndexingCompleted() {
        this.monitor.indexingCompleted();
        RecordedFailure firstFailure = this.firstFailure.get();
        if (firstFailure == null) {
            return;
        }
        if (firstFailure.throwable instanceof InterruptedException) {
            throw log.massIndexingThreadInterrupted((InterruptedException)firstFailure.throwable);
        }
        if (firstFailure.entityReference != null) {
            throw log.massIndexingFirstFailureOnEntity(this.failureCount.longValue(), firstFailure.entityReference, firstFailure.throwable.getMessage(), firstFailure.throwable);
        }
        throw log.massIndexingFirstFailure(this.failureCount.longValue(), firstFailure.throwable.getMessage(), firstFailure.throwable);
    }

    private RecordedFailure recordFailure(Exception exception, boolean recordSuppressed) {
        RecordedFailure recordedFailure = new RecordedFailure(exception);
        boolean isFirst = this.firstFailure.compareAndSet(null, recordedFailure);
        this.failureCount.increment();
        if (!isFirst && recordSuppressed) {
            this.firstFailure.get().throwable.addSuppressed(exception);
        }
        return recordedFailure;
    }

    private <T> EntityReference extractReferenceOrSuppress(HibernateOrmMassIndexingIndexedTypeContext<T> type, HibernateOrmMassIndexingSessionContext sessionContext, Object entity, Throwable throwable) {
        try {
            SessionImplementor session = sessionContext.session();
            Serializable identifier = session.getIdentifier(entity);
            return (EntityReference)EntityReferenceFactory.safeCreateEntityReference(sessionContext.entityReferenceFactory(), (String)type.jpaEntityName(), (Object)identifier, throwable::addSuppressed);
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private static class RecordedFailure {
        private final Throwable throwable;
        private volatile EntityReference entityReference;

        RecordedFailure(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

