/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class FailureHandledRunnable
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MassIndexingNotifier notifier;

    protected FailureHandledRunnable(MassIndexingNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public final void run() {
        boolean interrupted = false;
        boolean successful = false;
        try {
            this.runWithFailureHandler();
            successful = true;
        }
        catch (InterruptedException e) {
            interrupted = true;
            try {
                this.cleanUpOnInterruption();
            }
            catch (InterruptedException | RuntimeException e2) {
                e.addSuppressed(e2);
            }
            this.notifyInterrupted(e);
        }
        catch (RuntimeException e) {
            try {
                this.cleanUpOnFailure();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            catch (InterruptedException e2) {
                interrupted = true;
                e.addSuppressed(e2);
            }
            this.notifyFailure(e);
            throw e;
        }
        catch (Error e) {
            try {
                this.cleanUpOnFailure();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            catch (InterruptedException e2) {
                interrupted = true;
                e.addSuppressed(e2);
            }
            catch (Error e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (successful) {
            this.notifySuccess();
        }
    }

    protected abstract void runWithFailureHandler() throws InterruptedException;

    protected abstract void cleanUpOnInterruption() throws InterruptedException;

    protected abstract void cleanUpOnFailure() throws InterruptedException;

    protected final MassIndexingNotifier getNotifier() {
        return this.notifier;
    }

    protected void notifySuccess() {
    }

    protected void notifyInterrupted(InterruptedException exception) {
        this.notifier.notifyRunnableFailure((Exception)log.massIndexingThreadInterrupted(exception), log.massIndexerOperation());
    }

    protected void notifyFailure(RuntimeException exception) {
        this.notifier.notifyRunnableFailure(exception, log.massIndexerOperation());
    }
}

