/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.util.Collection;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;

public class LazyInitSearchSession
implements SearchSession {
    private final Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider;
    private final SessionImplementor sessionImplementor;
    private HibernateOrmSearchSession delegate;

    public LazyInitSearchSession(Supplier<? extends HibernateOrmSearchSessionMappingContext> mappingContextProvider, SessionImplementor sessionImplementor) {
        this.mappingContextProvider = mappingContextProvider;
        this.sessionImplementor = sessionImplementor;
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(Collection<? extends Class<? extends T>> types) {
        return this.getDelegate().search(types);
    }

    @Override
    public <T> SearchQuerySelectStep<?, EntityReference, T, SearchLoadingOptionsStep, ?, ?> search(SearchScope<T> scope) {
        return this.getDelegate().search(scope);
    }

    @Override
    public SearchSchemaManager schemaManager(Collection<? extends Class<?>> types) {
        return this.getDelegate().schemaManager(types);
    }

    @Override
    public SearchWorkspace workspace(Collection<? extends Class<?>> types) {
        return this.getDelegate().workspace(types);
    }

    @Override
    public MassIndexer massIndexer(Collection<? extends Class<?>> types) {
        return this.getDelegate().massIndexer(types);
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        return this.getDelegate().scope((Collection)types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.getDelegate().scope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManager toEntityManager() {
        return this.getDelegate().toEntityManager();
    }

    @Override
    public Session toOrmSession() {
        return this.getDelegate().toOrmSession();
    }

    @Override
    public SearchIndexingPlan indexingPlan() {
        return this.getDelegate().indexingPlan();
    }

    @Override
    public void automaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.getDelegate().automaticIndexingSynchronizationStrategy(synchronizationStrategy);
    }

    private HibernateOrmSearchSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = HibernateOrmSearchSession.get(this.mappingContextProvider.get(), this.sessionImplementor);
        }
        return this.delegate;
    }
}

