/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassPropertyModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class HibernateOrmClassRawTypeModel<T>
extends AbstractPojoHCAnnRawTypeModel<T, HibernateOrmBootstrapIntrospector> {
    private final HibernateOrmBasicClassTypeMetadata ormTypeMetadata;
    private List<HibernateOrmClassRawTypeModel<? super T>> ascendingSuperTypesCache;
    private List<HibernateOrmClassRawTypeModel<? super T>> descendingSuperTypesCache;

    HibernateOrmClassRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier, HibernateOrmBasicClassTypeMetadata ormTypeMetadata, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        super((AbstractPojoHCAnnBootstrapIntrospector)introspector, typeIdentifier, rawTypeDeclaringContext);
        this.ormTypeMetadata = ormTypeMetadata;
    }

    public Stream<HibernateOrmClassRawTypeModel<? super T>> ascendingSuperTypes() {
        if (this.ascendingSuperTypesCache == null) {
            this.ascendingSuperTypesCache = ((HibernateOrmBootstrapIntrospector)this.introspector).ascendingSuperClasses(this.xClass).map(xc -> ((HibernateOrmBootstrapIntrospector)this.introspector).typeModel(xc)).collect(Collectors.toList());
        }
        return this.ascendingSuperTypesCache.stream();
    }

    public Stream<HibernateOrmClassRawTypeModel<? super T>> descendingSuperTypes() {
        if (this.descendingSuperTypesCache == null) {
            this.descendingSuperTypesCache = ((HibernateOrmBootstrapIntrospector)this.introspector).descendingSuperClasses(this.xClass).map(xc -> ((HibernateOrmBootstrapIntrospector)this.introspector).typeModel(xc)).collect(Collectors.toList());
        }
        return this.descendingSuperTypesCache.stream();
    }

    protected HibernateOrmClassPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata;
        Member member;
        XProperty fieldAccessXProperty;
        ArrayList<XProperty> declaredXProperties = new ArrayList<XProperty>(2);
        XProperty methodAccessXProperty = (XProperty)this.declaredMethodAccessXPropertiesByName().get(propertyName);
        if (methodAccessXProperty != null) {
            declaredXProperties.add(methodAccessXProperty);
        }
        if ((fieldAccessXProperty = (XProperty)this.declaredFieldAccessXPropertiesByName().get(propertyName)) != null) {
            declaredXProperties.add(fieldAccessXProperty);
        }
        if ((member = this.findPropertyMember(propertyName, ormPropertyMetadata = this.findOrmPropertyMetadata(propertyName))) == null) {
            return null;
        }
        return new HibernateOrmClassPropertyModel((HibernateOrmBootstrapIntrospector)this.introspector, this, propertyName, declaredXProperties, ormPropertyMetadata, member);
    }

    private HibernateOrmBasicClassPropertyMetadata findOrmPropertyMetadata(String propertyName) {
        return this.findInSelfOrParents(t -> t.ormPropertyMetadataFromThisType(propertyName));
    }

    private HibernateOrmBasicClassPropertyMetadata ormPropertyMetadataFromThisType(String propertyName) {
        if (this.ormTypeMetadata != null) {
            return this.ormTypeMetadata.getClassPropertyMetadataOrNull(propertyName);
        }
        return null;
    }

    private Member findPropertyMember(String propertyName, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata) {
        if (ormPropertyMetadata != null) {
            Member memberFromHibernateOrmMetamodel = ormPropertyMetadata.getMember();
            if (memberFromHibernateOrmMetamodel instanceof Method) {
                return this.findInSelfOrParents(t -> t.declaredPropertyGetter(propertyName));
            }
            if (memberFromHibernateOrmMetamodel instanceof Field) {
                return this.findInSelfOrParents(t -> t.declaredPropertyField(propertyName));
            }
            return null;
        }
        Member getter = this.findInSelfOrParents(t -> t.declaredPropertyGetter(propertyName));
        if (getter != null) {
            return getter;
        }
        return this.findInSelfOrParents(t -> t.declaredPropertyField(propertyName));
    }

    private <T2> T2 findInSelfOrParents(Function<HibernateOrmClassRawTypeModel<?>, T2> getter) {
        return this.ascendingSuperTypes().map(getter).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

