/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanProvider;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmContainedBeanBeanHolderAdapter;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class HibernateOrmBeanContainerBeanProvider
implements BeanProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final BeanContainer.LifecycleOptions LIFECYCLE_OPTIONS = new BeanContainer.LifecycleOptions(){

        public boolean canUseCachedReferences() {
            return false;
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }
    };
    private final BeanContainer beanContainer;
    private final ReflectionBeanProvider fallback;
    private final BeanInstanceProducer fallbackInstanceProducer;

    HibernateOrmBeanContainerBeanProvider(BeanContainer beanContainer, final ReflectionBeanProvider fallback) {
        Contracts.assertNotNull((Object)beanContainer, (String)"beanContainer");
        this.beanContainer = beanContainer;
        this.fallback = fallback;
        this.fallbackInstanceProducer = new BeanInstanceProducer(){
            private final ReflectionBeanProvider delegate;
            {
                this.delegate = fallback;
            }

            public <B> B produceBeanInstance(Class<B> aClass) {
                return (B)this.delegate.forTypeNoClosingNecessary(aClass);
            }

            public <B> B produceBeanInstance(String s, Class<B> aClass) {
                return (B)this.delegate.forTypeAndNameNoClosingNecessary(aClass, s);
            }
        };
    }

    public void close() {
        this.fallback.close();
    }

    public <T> BeanHolder<T> forType(Class<T> typeReference) {
        ContainedBean containedBean = this.beanContainer.getBean(typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        BeanHolder result = new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
        try {
            result.get();
        }
        catch (Exception e) {
            new SuppressingCloser((Throwable)e).push(result);
            log.debugf(e, "Error resolving bean of type [%s] - using fallback", typeReference);
            try {
                result = BeanHolder.of((Object)this.fallbackInstanceProducer.produceBeanInstance(typeReference));
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
        return result;
    }

    public <T> BeanHolder<T> forTypeAndName(Class<T> typeReference, String nameReference) {
        ContainedBean containedBean = this.beanContainer.getBean(nameReference, typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        BeanHolder result = new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
        try {
            result.get();
        }
        catch (Exception e) {
            new SuppressingCloser((Throwable)e).push(result);
            log.debugf(e, "Error resolving bean [%s] of type [%s] - using fallback", nameReference, typeReference);
            try {
                result = BeanHolder.of((Object)this.fallbackInstanceProducer.produceBeanInstance(nameReference, typeReference));
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
        return result;
    }
}

