/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextThenSecondLevelCacheLookupStrategy;

public class HibernateOrmEntityIdEntityLoader<E>
implements HibernateOrmComposableEntityLoader<E> {
    private static final String IDS_PARAMETER_NAME = "ids";
    private final SessionImplementor session;
    private final EntityPersister entityPersister;
    private final PersistenceContextLookupStrategy persistenceContextLookup;
    private final EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;
    private final MutableEntityLoadingOptions loadingOptions;

    public static EntityLoaderFactory factory(SessionFactoryImplementor sessionFactory, EntityPersister entityPersister) {
        return new Factory(HibernateOrmUtils.toRootEntityType(sessionFactory, entityPersister));
    }

    private HibernateOrmEntityIdEntityLoader(EntityPersister entityPersister, SessionImplementor session, PersistenceContextLookupStrategy persistenceContextLookup, EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor, MutableEntityLoadingOptions loadingOptions) {
        this.entityPersister = entityPersister;
        this.session = session;
        this.persistenceContextLookup = persistenceContextLookup;
        this.cacheLookupStrategyImplementor = cacheLookupStrategyImplementor;
        this.loadingOptions = loadingOptions;
    }

    @Override
    public List<E> loadBlocking(List<EntityReference> references) {
        if (this.cacheLookupStrategyImplementor == null) {
            return this.doLoadEntities(references);
        }
        return HibernateOrmComposableEntityLoader.super.loadBlocking(references);
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        List<E> loadedEntities = this.doLoadEntities(references);
        Iterator<EntityReference> referencesIterator = references.iterator();
        Iterator<E> loadedEntityIterator = loadedEntities.iterator();
        while (referencesIterator.hasNext()) {
            EntityReference reference = referencesIterator.next();
            E loadedEntity = loadedEntityIterator.next();
            if (loadedEntity == null) continue;
            entitiesByReference.put(reference, loadedEntity);
        }
    }

    private List<E> doLoadEntities(List<EntityReference> references) {
        EntityKey key;
        int i;
        EntityKey[] keys = this.toEntityKeys(references);
        List loadedEntities = HibernateOrmEntityIdEntityLoader.createListContainingNulls(references.size());
        int fetchSize = this.loadingOptions.fetchSize();
        Query<?> query = this.createQuery(fetchSize);
        ArrayList<Serializable> ids = new ArrayList<Serializable>(fetchSize);
        for (i = 0; i < keys.length; ++i) {
            Object cacheHit;
            key = keys[i];
            if (this.cacheLookupStrategyImplementor != null && (cacheHit = this.cacheLookupStrategyImplementor.lookup(key)) != null) {
                EntityReference reference = references.get(i);
                loadedEntities.set(i, this.castOrNull(reference, cacheHit));
                keys[i] = null;
                continue;
            }
            ids.add(key.getIdentifier());
            if (ids.size() < fetchSize) continue;
            query.setParameterList(IDS_PARAMETER_NAME, ids);
            query.getResultList();
            ids.clear();
        }
        if (!ids.isEmpty()) {
            query.setParameterList(IDS_PARAMETER_NAME, ids);
            query.getResultList();
        }
        for (i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key == null) continue;
            EntityReference reference = references.get(i);
            Object loaded = this.persistenceContextLookup.lookup(key);
            loadedEntities.set(i, this.castOrNull(reference, loaded));
        }
        return loadedEntities;
    }

    private E castOrNull(EntityReference reference, Object loadedEntity) {
        if (!HibernateOrmEntityIdEntityLoader.hasExpectedType(reference, loadedEntity)) {
            return null;
        }
        return (E)loadedEntity;
    }

    private Query<?> createQuery(int fetchSize) {
        Query<?> query = HibernateOrmUtils.createQueryForLoadByUniqueProperty(this.session, this.entityPersister, this.entityPersister.getIdentifierPropertyName(), IDS_PARAMETER_NAME);
        query.setFetchSize(fetchSize);
        EntityGraphHint<?> entityGraphHint = this.loadingOptions.entityGraphHintOrNullForType(this.entityPersister);
        if (entityGraphHint != null) {
            query.applyGraph(entityGraphHint.graph, entityGraphHint.semantic);
        }
        return query;
    }

    private EntityKey[] toEntityKeys(List<EntityReference> references) {
        EntityKey[] entityKeys = new EntityKey[references.size()];
        for (int i = 0; i < references.size(); ++i) {
            EntityKey entityKey;
            EntityReference reference = references.get(i);
            entityKeys[i] = entityKey = this.session.generateEntityKey((Serializable)reference.id(), this.entityPersister);
        }
        return entityKeys;
    }

    private static <T> List<T> createListContainingNulls(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    private static boolean hasExpectedType(EntityReference reference, Object loadedEntity) {
        return reference.type().isInstance(loadedEntity);
    }

    private static class Factory
    implements EntityLoaderFactory {
        private final EntityPersister rootEntityPersister;

        private Factory(EntityPersister rootEntityPersister) {
            this.rootEntityPersister = rootEntityPersister;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.rootEntityPersister.equals(other.rootEntityPersister);
        }

        @Override
        public int hashCode() {
            return this.rootEntityPersister.hashCode();
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<E> create(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            HibernateOrmComposableEntityLoader<?> result = this.doCreate(targetEntityTypeContext.entityPersister(), session, cacheLookupStrategy, loadingOptions);
            return result;
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<? extends E> create(List<HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            EntityPersister commonSuperType = Factory.toMostSpecificCommonEntitySuperType(session, targetEntityTypeContexts);
            HibernateOrmComposableEntityLoader<?> result = this.doCreate(commonSuperType, session, cacheLookupStrategy, loadingOptions);
            return result;
        }

        private HibernateOrmComposableEntityLoader<?> doCreate(EntityPersister entityPersister, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;
            if (!this.rootEntityPersister.getMappedClass().isAssignableFrom(entityPersister.getMappedClass())) {
                throw new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. There is a bug in Hibernate Search, please report it. Expected root entity name: " + this.rootEntityPersister.getEntityName() + " Targeted entity name: " + entityPersister.getEntityName());
            }
            PersistenceContextLookupStrategy persistenceContextLookup = PersistenceContextLookupStrategy.create(session);
            switch (cacheLookupStrategy) {
                case SKIP: {
                    cacheLookupStrategyImplementor = null;
                    break;
                }
                case PERSISTENCE_CONTEXT: {
                    cacheLookupStrategyImplementor = persistenceContextLookup;
                    break;
                }
                case PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE: {
                    cacheLookupStrategyImplementor = PersistenceContextThenSecondLevelCacheLookupStrategy.create(entityPersister, session);
                    break;
                }
                default: {
                    throw new AssertionFailure("Unexpected cache lookup strategy: " + (Object)((Object)cacheLookupStrategy));
                }
            }
            return new HibernateOrmEntityIdEntityLoader(entityPersister, session, persistenceContextLookup, cacheLookupStrategyImplementor, loadingOptions);
        }

        private static EntityPersister toMostSpecificCommonEntitySuperType(SessionImplementor session, Iterable<? extends HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts) {
            MetamodelImplementor metamodel = session.getSessionFactory().getMetamodel();
            EntityPersister result = null;
            for (HibernateOrmLoadingIndexedTypeContext hibernateOrmLoadingIndexedTypeContext : targetEntityTypeContexts) {
                EntityPersister type = hibernateOrmLoadingIndexedTypeContext.entityPersister();
                if (result == null) {
                    result = type;
                    continue;
                }
                result = HibernateOrmUtils.toMostSpecificCommonEntitySuperType(metamodel, result, type);
            }
            return result;
        }
    }
}

