/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmByTypeEntityLoader<T>
implements EntityLoader<EntityReference, T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, HibernateOrmComposableEntityLoader<? extends T>> delegatesByEntityName;

    HibernateOrmByTypeEntityLoader(Map<String, HibernateOrmComposableEntityLoader<? extends T>> delegatesByEntityName) {
        this.delegatesByEntityName = delegatesByEntityName;
    }

    public List<T> loadBlocking(List<EntityReference> references) {
        HibernateOrmComposableEntityLoader delegate;
        LinkedHashMap objectsByReference = new LinkedHashMap(references.size());
        HashMap<HibernateOrmComposableEntityLoader, List> referencesByDelegate = new HashMap<HibernateOrmComposableEntityLoader, List>();
        for (EntityReference entityReference : references) {
            objectsByReference.put(entityReference, null);
            delegate = this.delegateForType(entityReference.name());
            referencesByDelegate.computeIfAbsent(delegate, ignored -> new ArrayList()).add(entityReference);
        }
        for (Map.Entry entry : referencesByDelegate.entrySet()) {
            delegate = (HibernateOrmComposableEntityLoader)entry.getKey();
            List referencesForDelegate = (List)entry.getValue();
            delegate.loadBlocking(referencesForDelegate, objectsByReference);
        }
        ArrayList result = new ArrayList(references.size());
        for (EntityReference reference : references) {
            result.add(objectsByReference.get(reference));
        }
        return result;
    }

    private HibernateOrmComposableEntityLoader<? extends T> delegateForType(String entityName) {
        HibernateOrmComposableEntityLoader<? extends T> delegate = this.delegatesByEntityName.get(entityName);
        if (delegate == null) {
            throw log.unexpectedSearchHitEntityName(entityName, this.delegatesByEntityName.keySet());
        }
        return delegate;
    }
}

