/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByTypeEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingMappingContext;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;

public class EntityLoaderBuilder<E> {
    private final SessionImplementor session;
    private final Set<? extends HibernateOrmLoadingIndexedTypeContext> concreteIndexedTypes;
    private EntityLoadingCacheLookupStrategy cacheLookupStrategy;

    public EntityLoaderBuilder(HibernateOrmLoadingMappingContext mappingContext, HibernateOrmLoadingSessionContext sessionContext, Set<? extends HibernateOrmLoadingIndexedTypeContext> concreteIndexedTypes) {
        this.session = sessionContext.session();
        this.concreteIndexedTypes = concreteIndexedTypes;
        this.cacheLookupStrategy = mappingContext.cacheLookupStrategy();
    }

    public void cacheLookupStrategy(EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.cacheLookupStrategy = cacheLookupStrategy;
    }

    public EntityLoader<EntityReference, ? extends E> build(MutableEntityLoadingOptions mutableLoadingOptions) {
        if (this.concreteIndexedTypes.size() == 1) {
            HibernateOrmLoadingIndexedTypeContext typeContext = this.concreteIndexedTypes.iterator().next();
            return this.createForSingleType(typeContext, mutableLoadingOptions);
        }
        HashMap<EntityLoaderFactory, List> typesByEntityLoaderFactory = new HashMap<EntityLoaderFactory, List>(this.concreteIndexedTypes.size());
        for (HibernateOrmLoadingIndexedTypeContext hibernateOrmLoadingIndexedTypeContext : this.concreteIndexedTypes) {
            EntityLoaderFactory loaderFactoryForType = hibernateOrmLoadingIndexedTypeContext.loaderFactory();
            typesByEntityLoaderFactory.computeIfAbsent(loaderFactoryForType, ignored -> new ArrayList()).add(hibernateOrmLoadingIndexedTypeContext);
        }
        if (typesByEntityLoaderFactory.size() == 1) {
            Map.Entry entry = typesByEntityLoaderFactory.entrySet().iterator().next();
            EntityLoaderFactory entityLoaderFactory = (EntityLoaderFactory)entry.getKey();
            List types = (List)entry.getValue();
            return this.createForMultipleTypes(entityLoaderFactory, types, mutableLoadingOptions);
        }
        HashMap delegateByEntityName = new HashMap(this.concreteIndexedTypes.size());
        for (Map.Entry entry : typesByEntityLoaderFactory.entrySet()) {
            EntityLoaderFactory loaderFactory = (EntityLoaderFactory)entry.getKey();
            List types = (List)entry.getValue();
            HibernateOrmComposableEntityLoader<E> loader = this.createForMultipleTypes(loaderFactory, types, mutableLoadingOptions);
            for (HibernateOrmLoadingIndexedTypeContext type : types) {
                delegateByEntityName.put(type.jpaEntityName(), loader);
            }
        }
        return new HibernateOrmByTypeEntityLoader(delegateByEntityName);
    }

    private HibernateOrmComposableEntityLoader<? extends E> createForSingleType(HibernateOrmLoadingIndexedTypeContext typeContext, MutableEntityLoadingOptions mutableLoadingOptions) {
        return typeContext.loaderFactory().create(typeContext, this.session, this.cacheLookupStrategy, mutableLoadingOptions);
    }

    private HibernateOrmComposableEntityLoader<? extends E> createForMultipleTypes(EntityLoaderFactory loaderFactory, List<HibernateOrmLoadingIndexedTypeContext> types, MutableEntityLoadingOptions mutableLoadingOptions) {
        return loaderFactory.create(types, this.session, this.cacheLookupStrategy, mutableLoadingOptions);
    }
}

