/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmContainedTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmIndexedTypeContext;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeIdentifierResolver;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateOrmTypeContextContainer
implements HibernateOrmListenerTypeContextProvider,
HibernateOrmSessionTypeContextProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<PojoRawTypeIdentifier<?>, HibernateOrmIndexedTypeContext<?>> indexedTypeContexts = new LinkedHashMap();
    private final Map<String, HibernateOrmIndexedTypeContext<?>> indexedTypeContextsByHibernateOrmEntityName = new LinkedHashMap();
    private final Map<String, HibernateOrmIndexedTypeContext<?>> indexedTypeContextsByJpaEntityName = new LinkedHashMap();
    private final Map<PojoRawTypeIdentifier<?>, HibernateOrmContainedTypeContext<?>> containedTypeContexts = new LinkedHashMap();
    private final Map<String, HibernateOrmContainedTypeContext<?>> containedTypeContextsByHibernateOrmEntityName = new LinkedHashMap();
    private final HibernateOrmRawTypeIdentifierResolver typeIdentifierResolver;

    private HibernateOrmTypeContextContainer(Builder builder, SessionFactoryImplementor sessionFactory) {
        PojoRawTypeIdentifier typeIdentifier;
        for (Object contextBuilder : builder.indexedTypeContextBuilders) {
            HibernateOrmIndexedTypeContext indexedTypeContext = ((HibernateOrmIndexedTypeContext.Builder)contextBuilder).build(sessionFactory);
            typeIdentifier = indexedTypeContext.typeIdentifier();
            this.indexedTypeContexts.put(typeIdentifier, indexedTypeContext);
            this.indexedTypeContextsByHibernateOrmEntityName.put(indexedTypeContext.hibernateOrmEntityName(), indexedTypeContext);
            this.indexedTypeContextsByJpaEntityName.put(indexedTypeContext.jpaEntityName(), indexedTypeContext);
        }
        for (Object contextBuilder : builder.containedTypeContextBuilders) {
            HibernateOrmContainedTypeContext containedTypeContext = ((HibernateOrmContainedTypeContext.Builder)contextBuilder).build(sessionFactory);
            typeIdentifier = containedTypeContext.typeIdentifier();
            this.containedTypeContexts.put(typeIdentifier, containedTypeContext);
            this.containedTypeContextsByHibernateOrmEntityName.put(containedTypeContext.hibernateOrmEntityName(), containedTypeContext);
        }
        this.typeIdentifierResolver = builder.basicTypeMetadataProvider.getTypeIdentifierResolver();
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return this.indexedTypeContexts.get(typeIdentifier);
    }

    public HibernateOrmIndexedTypeContext<?> indexedForJpaEntityName(String indexName) {
        return this.indexedTypeContextsByJpaEntityName.get(indexName);
    }

    public <E> HibernateOrmContainedTypeContext<E> containedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return this.containedTypeContexts.get(typeIdentifier);
    }

    @Override
    public AbstractHibernateOrmTypeContext<?> forHibernateOrmEntityName(String hibernateOrmEntityName) {
        AbstractHibernateOrmTypeContext result = this.indexedTypeContextsByHibernateOrmEntityName.get(hibernateOrmEntityName);
        if (result != null) {
            return result;
        }
        result = this.containedTypeContextsByHibernateOrmEntityName.get(hibernateOrmEntityName);
        return result;
    }

    @Override
    public <T> PojoRawTypeIdentifier<T> typeIdentifierForJavaClass(Class<T> clazz) {
        return this.typeIdentifierResolver.resolveByJavaClass(clazz);
    }

    @Override
    public PojoRawTypeIdentifier<?> typeIdentifierForHibernateOrmEntityName(String entityName) {
        PojoRawTypeIdentifier<?> result = this.typeIdentifierResolver.resolveByHibernateOrmEntityName(entityName);
        if (result == null) {
            throw log.invalidEntityName(entityName, this.typeIdentifierResolver.allKnownHibernateOrmEntityNames());
        }
        return result;
    }

    @Override
    public PojoRawTypeIdentifier<?> typeIdentifierForEntityName(String entityName) {
        PojoRawTypeIdentifier<?> result = this.typeIdentifierResolver.resolveByJpaOrHibernateOrmEntityName(entityName);
        if (result == null) {
            throw log.invalidEntityName(entityName, this.typeIdentifierResolver.allKnownJpaOrHibernateOrmEntityNames());
        }
        return result;
    }

    Collection<HibernateOrmIndexedTypeContext<?>> allIndexed() {
        return this.indexedTypeContexts.values();
    }

    static class Builder {
        private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
        private final List<HibernateOrmIndexedTypeContext.Builder<?>> indexedTypeContextBuilders = new ArrayList();
        private final List<HibernateOrmContainedTypeContext.Builder<?>> containedTypeContextBuilders = new ArrayList();

        Builder(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider) {
            this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        }

        <E> HibernateOrmIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmIndexedTypeContext.Builder builder = new HibernateOrmIndexedTypeContext.Builder(typeModel.typeIdentifier(), jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        <E> HibernateOrmContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            HibernateOrmContainedTypeContext.Builder builder = new HibernateOrmContainedTypeContext.Builder(typeModel.typeIdentifier(), jpaEntityName, this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName));
            this.containedTypeContextBuilders.add(builder);
            return builder;
        }

        HibernateOrmTypeContextContainer build(SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmTypeContextContainer(this, sessionFactory);
        }
    }
}

