/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.mapper.orm.mapping.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByIdEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmCriteriaEntityLoader;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmIndexedTypeContext<E>
extends AbstractHibernateOrmTypeContext<E>
implements SearchIndexedEntity,
HibernateOrmSessionIndexedTypeContext<E>,
HibernateOrmScopeIndexedTypeContext<E> {
    private final boolean documentIdIsEntityId;
    private final EntityLoaderFactory loaderFactory;
    private final IdentifierMapping identifierMapping;
    private final MappedIndexManager indexManager;

    private HibernateOrmIndexedTypeContext(Builder<E> builder, SessionFactoryImplementor sessionFactory) {
        super(sessionFactory, ((Builder)builder).typeIdentifier, ((Builder)builder).jpaEntityName, ((Builder)builder).hibernateOrmEntityName);
        if (this.getEntityPersister().getIdentifierPropertyName().equals(((Builder)builder).documentIdSourcePropertyName)) {
            this.documentIdIsEntityId = true;
            this.loaderFactory = HibernateOrmByIdEntityLoader.factory(sessionFactory, this.getEntityPersister());
        } else {
            this.documentIdIsEntityId = false;
            EntityTypeDescriptor typeDescriptor = this.getEntityTypeDescriptor();
            SingularAttribute documentIdSourceAttribute = typeDescriptor.getSingularAttribute(((Builder)builder).documentIdSourcePropertyName);
            this.loaderFactory = HibernateOrmCriteriaEntityLoader.factory(typeDescriptor, documentIdSourceAttribute, ((Builder)builder).documentIdSourcePropertyHandle);
        }
        this.identifierMapping = ((Builder)builder).identifierMapping;
        this.indexManager = ((Builder)builder).indexManager;
    }

    @Override
    public String jpaName() {
        return this.getJpaEntityName();
    }

    @Override
    public Class<?> javaClass() {
        return this.getTypeIdentifier().getJavaClass();
    }

    @Override
    public IndexManager indexManager() {
        return this.indexManager.toAPI();
    }

    @Override
    public Object toIndexingPlanProvidedId(Object entityId) {
        if (this.documentIdIsEntityId) {
            return entityId;
        }
        return null;
    }

    @Override
    public IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public EntityLoaderFactory getLoaderFactory() {
        return this.loaderFactory;
    }

    static class Builder<E>
    implements PojoIndexedTypeExtendedMappingCollector {
        private final PojoRawTypeIdentifier<E> typeIdentifier;
        private final String jpaEntityName;
        private final String hibernateOrmEntityName;
        private String documentIdSourcePropertyName;
        private ValueReadHandle<?> documentIdSourcePropertyHandle;
        private IdentifierMapping identifierMapping;
        private MappedIndexManager indexManager;

        Builder(PojoRawTypeIdentifier<E> typeIdentifier, String jpaEntityName, String hibernateOrmEntityName) {
            this.typeIdentifier = typeIdentifier;
            this.jpaEntityName = jpaEntityName;
            this.hibernateOrmEntityName = hibernateOrmEntityName;
        }

        public void documentIdSourceProperty(PojoPropertyModel<?> documentIdSourceProperty) {
            this.documentIdSourcePropertyName = documentIdSourceProperty.getName();
            this.documentIdSourcePropertyHandle = documentIdSourceProperty.getHandle();
        }

        public void identifierMapping(IdentifierMapping identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        public void indexManager(MappedIndexManager indexManager) {
            this.indexManager = indexManager;
        }

        public HibernateOrmIndexedTypeContext<E> build(SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmIndexedTypeContext(this, sessionFactory);
        }
    }
}

