/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.mapper.orm.logging.impl.HibernateOrmEventContextMessages;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.util.common.impl.Futures;

public class SearchSchemaManagerImpl
implements SearchSchemaManager {
    private final PojoScopeSchemaManager delegate;

    public SearchSchemaManagerImpl(PojoScopeSchemaManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void validate() {
        this.doOperation(PojoScopeSchemaManager::validate);
    }

    @Override
    public void createIfMissing() {
        this.doOperation(PojoScopeSchemaManager::createIfMissing);
    }

    @Override
    public void createOrValidate() {
        this.doOperation(PojoScopeSchemaManager::createOrValidate);
    }

    @Override
    public void createOrUpdate() {
        this.doOperation(PojoScopeSchemaManager::createOrUpdate);
    }

    @Override
    public void dropIfExisting() {
        this.doOperation(PojoScopeSchemaManager::dropIfExisting);
    }

    @Override
    public void dropAndCreate() {
        this.doOperation(PojoScopeSchemaManager::dropAndCreate);
    }

    private void doOperation(BiFunction<PojoScopeSchemaManager, FailureCollector, CompletableFuture<?>> operation) {
        RootFailureCollector failureCollector = new RootFailureCollector(HibernateOrmEventContextMessages.INSTANCE.schemaManagement());
        try {
            Futures.unwrappedExceptionJoin(operation.apply(this.delegate, (FailureCollector)failureCollector));
        }
        catch (RuntimeException e) {
            failureCollector.withContext(EventContexts.getDefault()).add((Throwable)e);
        }
        failureCollector.checkNoFailure();
    }
}

