/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.PersistenceContextThenSecondLevelCacheLookupStrategy;

public class HibernateOrmByIdEntityLoader<E>
implements HibernateOrmComposableEntityLoader<E> {
    private final Session session;
    private final EntityPersister targetEntityType;
    private final EntityLoadingCacheLookupStrategyImplementor<?> cacheLookupStrategyImplementor;
    private final MutableEntityLoadingOptions loadingOptions;

    public static EntityLoaderFactory factory(SessionFactoryImplementor sessionFactory, EntityPersister entityType) {
        return new Factory(HibernateOrmByIdEntityLoader.toRootEntityType(sessionFactory, entityType));
    }

    private HibernateOrmByIdEntityLoader(EntityPersister targetEntityType, Session session, EntityLoadingCacheLookupStrategyImplementor<E> cacheLookupStrategyImplementor, MutableEntityLoadingOptions loadingOptions) {
        this.targetEntityType = targetEntityType;
        this.session = session;
        this.cacheLookupStrategyImplementor = cacheLookupStrategyImplementor;
        this.loadingOptions = loadingOptions;
    }

    @Override
    public List<E> loadBlocking(List<EntityReference> references) {
        if (this.cacheLookupStrategyImplementor == null) {
            return this.loadEntities(references);
        }
        return HibernateOrmComposableEntityLoader.super.loadBlocking(references);
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        List<EntityReference> missingFromCacheReferences = this.loadBlockingFromCache(references, entitiesByReference);
        if (missingFromCacheReferences.isEmpty()) {
            return;
        }
        List<E> loadedEntities = this.loadEntities(missingFromCacheReferences);
        Iterator<EntityReference> referencesIterator = missingFromCacheReferences.iterator();
        Iterator<E> loadedEntityIterator = loadedEntities.iterator();
        while (referencesIterator.hasNext()) {
            EntityReference reference = referencesIterator.next();
            E loadedEntity = loadedEntityIterator.next();
            if (loadedEntity == null) continue;
            entitiesByReference.put(reference, loadedEntity);
        }
    }

    private List<EntityReference> loadBlockingFromCache(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        if (this.cacheLookupStrategyImplementor == null) {
            return references;
        }
        ArrayList<EntityReference> missingFromCacheReferences = new ArrayList<EntityReference>(references.size());
        for (EntityReference reference : references) {
            Object entityId = reference.getId();
            Object loadedEntity = this.cacheLookupStrategyImplementor.lookup(entityId);
            if (loadedEntity == null) {
                missingFromCacheReferences.add(reference);
                continue;
            }
            if (HibernateOrmByIdEntityLoader.hasExpectedType(reference, loadedEntity)) {
                entitiesByReference.put(reference, loadedEntity);
                continue;
            }
            entitiesByReference.put(reference, null);
        }
        return missingFromCacheReferences;
    }

    private List<E> loadEntities(List<EntityReference> references) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>(references.size());
        for (EntityReference reference : references) {
            ids.add((Serializable)reference.getId());
        }
        List loadedEntities = this.getMultiAccess().multiLoad(ids);
        for (int i = 0; i < references.size(); ++i) {
            Object loadedEntity;
            EntityReference reference = references.get(i);
            if (HibernateOrmByIdEntityLoader.hasExpectedType(reference, loadedEntity = loadedEntities.get(i))) continue;
            loadedEntities.set(i, null);
        }
        return loadedEntities;
    }

    private MultiIdentifierLoadAccess<?> getMultiAccess() {
        MultiIdentifierLoadAccess multiAccess = this.session.byMultipleIds(this.targetEntityType.getEntityName());
        multiAccess.withBatchSize(this.loadingOptions.getFetchSize());
        return multiAccess;
    }

    private static boolean hasExpectedType(EntityReference reference, Object loadedEntity) {
        return reference.getType().isInstance(loadedEntity);
    }

    private static EntityPersister toRootEntityType(SessionFactoryImplementor sessionFactory, EntityPersister entityType) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        String rootEntityName = metamodel.entityPersister(entityType.getEntityName()).getRootEntityName();
        return metamodel.entityPersister(rootEntityName).getEntityPersister();
    }

    private static class Factory
    implements EntityLoaderFactory {
        private final EntityPersister rootEntityType;

        private Factory(EntityPersister rootEntityType) {
            this.rootEntityType = rootEntityType;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.rootEntityType.equals(other.rootEntityType);
        }

        @Override
        public int hashCode() {
            return this.rootEntityType.hashCode();
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<E> create(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            HibernateOrmComposableEntityLoader<?> result = this.doCreate(targetEntityTypeContext.getEntityPersister(), session, cacheLookupStrategy, loadingOptions);
            return result;
        }

        @Override
        public <E> HibernateOrmComposableEntityLoader<? extends E> create(List<HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            EntityPersister commonSuperType = Factory.toMostSpecificCommonEntitySuperType(session, targetEntityTypeContexts);
            HibernateOrmComposableEntityLoader<?> result = this.doCreate(commonSuperType, session, cacheLookupStrategy, loadingOptions);
            return result;
        }

        private HibernateOrmComposableEntityLoader<?> doCreate(EntityPersister targetEntityType, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            EntityLoadingCacheLookupStrategyImplementor cacheLookupStrategyImplementor;
            if (!this.rootEntityType.getMappedClass().isAssignableFrom(targetEntityType.getMappedClass())) {
                throw new AssertionFailure("Some types among the targeted entity types are not subclasses of the expected root entity type. There is a bug in Hibernate Search, please report it. Expected root entity name: " + this.rootEntityType.getEntityName() + " Targeted entity name: " + targetEntityType.getEntityName());
            }
            switch (cacheLookupStrategy) {
                case SKIP: {
                    cacheLookupStrategyImplementor = null;
                    break;
                }
                case PERSISTENCE_CONTEXT: {
                    cacheLookupStrategyImplementor = PersistenceContextLookupStrategy.create(targetEntityType, session);
                    break;
                }
                case PERSISTENCE_CONTEXT_THEN_SECOND_LEVEL_CACHE: {
                    cacheLookupStrategyImplementor = PersistenceContextThenSecondLevelCacheLookupStrategy.create(targetEntityType, session);
                    break;
                }
                default: {
                    throw new AssertionFailure("Unexpected cache lookup strategy: " + (Object)((Object)cacheLookupStrategy));
                }
            }
            return new HibernateOrmByIdEntityLoader(targetEntityType, (Session)session, cacheLookupStrategyImplementor, loadingOptions);
        }

        private static EntityPersister toMostSpecificCommonEntitySuperType(SessionImplementor session, Iterable<? extends HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts) {
            MetamodelImplementor metamodel = session.getSessionFactory().getMetamodel();
            EntityPersister result = null;
            for (HibernateOrmLoadingIndexedTypeContext hibernateOrmLoadingIndexedTypeContext : targetEntityTypeContexts) {
                EntityPersister type = hibernateOrmLoadingIndexedTypeContext.getEntityPersister();
                if (result == null) {
                    result = type;
                    continue;
                }
                result = Factory.toMostSpecificCommonEntitySuperType(metamodel, result, type);
            }
            return result;
        }

        private static EntityPersister toMostSpecificCommonEntitySuperType(MetamodelImplementor metamodel, EntityPersister type1, EntityPersister type2) {
            EntityPersister superTypeCandidate = type1;
            while (superTypeCandidate != null && !HibernateOrmUtils.isSuperTypeOf(superTypeCandidate, type2)) {
                String superSuperTypeEntityName = superTypeCandidate.getEntityMetamodel().getSuperclass();
                superTypeCandidate = superSuperTypeEntityName == null ? null : metamodel.entityPersister(superSuperTypeEntityName).getEntityPersister();
            }
            if (superTypeCandidate == null) {
                throw new AssertionFailure("Cannot find a common entity supertype for " + type1.getEntityName() + " and " + type2.getEntityName() + ". There is a bug in Hibernate Search, please report it.");
            }
            return superTypeCandidate;
        }
    }
}

