/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.util.stream.Stream;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapValueReadHandle;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmDynamicMapPropertyModel<T>
implements PojoPropertyModel<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmBootstrapIntrospector introspector;
    private final HibernateOrmDynamicMapRawTypeModel holderTypeModel;
    private final String name;
    private final HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata;
    private ValueReadHandle<T> handle;
    private PojoGenericTypeModel<T> typeModel;

    HibernateOrmDynamicMapPropertyModel(HibernateOrmBootstrapIntrospector introspector, HibernateOrmDynamicMapRawTypeModel holderTypeModel, String name, HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata) {
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.ormPropertyMetadata = ormPropertyMetadata;
    }

    public String getName() {
        return this.name;
    }

    public Stream<Annotation> getAnnotations() {
        return Stream.empty();
    }

    public PojoGenericTypeModel<T> getTypeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.ormPropertyMetadata.getTypeModelFactory().create(this.introspector);
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.holderTypeModel, e);
            }
        }
        return this.typeModel;
    }

    public ValueReadHandle<T> getHandle() {
        if (this.handle == null) {
            try {
                this.handle = new HibernateOrmDynamicMapValueReadHandle(this.name, this.getTypeModel().getRawType().getTypeIdentifier().getJavaClass());
            }
            catch (RuntimeException e) {
                throw log.errorRetrievingPropertyTypeModel(this.getName(), this.holderTypeModel, e);
            }
        }
        return this.handle;
    }
}

