/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.automaticindexing.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationConfigurationContext;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class SyncAutomaticIndexingSynchronizationStrategy
implements AutomaticIndexingSynchronizationStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final AutomaticIndexingSynchronizationStrategy INSTANCE = new SyncAutomaticIndexingSynchronizationStrategy();

    private SyncAutomaticIndexingSynchronizationStrategy() {
    }

    public String toString() {
        return AutomaticIndexingSynchronizationStrategy.class.getSimpleName() + ".sync()";
    }

    @Override
    public void apply(AutomaticIndexingSynchronizationConfigurationContext context) {
        context.documentCommitStrategy(DocumentCommitStrategy.FORCE);
        context.documentRefreshStrategy(DocumentRefreshStrategy.FORCE);
        context.indexingFutureHandler(future -> {
            SearchIndexingPlanExecutionReport report = (SearchIndexingPlanExecutionReport)Futures.unwrappedExceptionJoin((CompletableFuture)future);
            report.getThrowable().ifPresent(t -> {
                throw log.indexingFailure(t.getMessage(), report.getFailingEntities(), (Throwable)t);
            });
        });
    }
}

