/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderFactory;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class HibernateOrmCriteriaEntityLoader<E>
implements HibernateOrmComposableEntityLoader<E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EntityTypeDescriptor<? extends E> entityType;
    private final SingularAttribute<? super E, ?> documentIdSourceAttribute;
    private final ValueReadHandle<?> documentIdSourceHandle;
    private final Session session;
    private final MutableEntityLoadingOptions loadingOptions;

    public static <E> EntityLoaderFactory factory(EntityTypeDescriptor<E> entityType, SingularAttribute<? super E, ?> documentIdSourceAttribute, ValueReadHandle<?> documentIdSourceHandle) {
        return new Factory(entityType, documentIdSourceAttribute, documentIdSourceHandle);
    }

    private HibernateOrmCriteriaEntityLoader(EntityTypeDescriptor<? extends E> entityType, SingularAttribute<? super E, ?> documentIdSourceAttribute, ValueReadHandle<?> documentIdSourceHandle, Session session, MutableEntityLoadingOptions loadingOptions) {
        this.entityType = entityType;
        this.documentIdSourceAttribute = documentIdSourceAttribute;
        this.documentIdSourceHandle = documentIdSourceHandle;
        this.session = session;
        this.loadingOptions = loadingOptions;
    }

    @Override
    public void loadBlocking(List<EntityReference> references, Map<? super EntityReference, ? super E> entitiesByReference) {
        HashMap<Object, EntityReference> documentIdSourceValueToReference = new HashMap<Object, EntityReference>();
        for (EntityReference reference : references) {
            documentIdSourceValueToReference.put(reference.getId(), reference);
        }
        List<E> loadedEntities = this.loadEntities(documentIdSourceValueToReference.keySet());
        for (E loadedEntity : loadedEntities) {
            Object unproxied = Hibernate.unproxy(loadedEntity);
            Object documentIdSourceValue = this.documentIdSourceHandle.get(unproxied);
            EntityReference reference = (EntityReference)documentIdSourceValueToReference.get(documentIdSourceValue);
            entitiesByReference.put(reference, loadedEntity);
        }
    }

    private List<? extends E> loadEntities(Collection<Object> documentIdSourceValues) {
        CriteriaBuilder criteriaBuilder = this.session.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityType.getJavaType());
        Root root = criteriaQuery.from(this.entityType);
        Path documentIdSourcePropertyInRoot = root.get(this.documentIdSourceAttribute);
        criteriaQuery.where((Expression)documentIdSourcePropertyInRoot.in(documentIdSourceValues));
        Query query = this.session.createQuery(criteriaQuery);
        query.setFetchSize(this.loadingOptions.getFetchSize());
        return query.getResultList();
    }

    private static class Factory<E>
    implements EntityLoaderFactory {
        private final EntityTypeDescriptor<E> entityType;
        private final SingularAttribute<? super E, ?> documentIdSourceAttribute;
        private final ValueReadHandle<?> documentIdSourceHandle;

        private Factory(EntityTypeDescriptor<E> entityType, SingularAttribute<? super E, ?> documentIdSourceAttribute, ValueReadHandle<?> documentIdSourceHandle) {
            this.entityType = entityType;
            this.documentIdSourceAttribute = documentIdSourceAttribute;
            this.documentIdSourceHandle = documentIdSourceHandle;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.entityType.equals(other.entityType) && this.documentIdSourceAttribute.equals(other.documentIdSourceAttribute) && this.documentIdSourceHandle.equals(other.documentIdSourceHandle);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.entityType, this.documentIdSourceAttribute, this.documentIdSourceHandle);
        }

        public <E2> HibernateOrmComposableEntityLoader<E2> create(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            return this.doCreate(targetEntityTypeContext, session, cacheLookupStrategy, loadingOptions);
        }

        public <E2> HibernateOrmComposableEntityLoader<? extends E2> create(List<HibernateOrmLoadingIndexedTypeContext> targetEntityTypeContexts, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            if (targetEntityTypeContexts.size() != 1) {
                throw new AssertionFailure("Attempt to use a criteria-based entity loader with multiple target entity types. There is a bug in Hibernate Search, please report it. Expected entity name: " + this.entityType.getName() + " Targeted entity names: " + targetEntityTypeContexts.stream().map(HibernateOrmLoadingIndexedTypeContext::getJpaEntityName).collect(Collectors.toList()));
            }
            return this.doCreate(targetEntityTypeContexts.get(0), session, cacheLookupStrategy, loadingOptions);
        }

        private <E2> HibernateOrmComposableEntityLoader<E2> doCreate(HibernateOrmLoadingIndexedTypeContext targetEntityTypeContext, SessionImplementor session, EntityLoadingCacheLookupStrategy cacheLookupStrategy, MutableEntityLoadingOptions loadingOptions) {
            if (!this.entityType.getName().equals(targetEntityTypeContext.getJpaEntityName())) {
                throw new AssertionFailure("Attempt to use a criteria-based entity loader with an unexpected target entity type. There is a bug in Hibernate Search, please report it. Expected entity name: " + this.entityType.getName() + " Targeted entity name: " + targetEntityTypeContext.getJpaEntityName());
            }
            HibernateOrmCriteriaEntityLoader result = new HibernateOrmCriteriaEntityLoader(this.entityType, this.documentIdSourceAttribute, this.documentIdSourceHandle, (Session)session, loadingOptions);
            if (!EntityLoadingCacheLookupStrategy.SKIP.equals((Object)cacheLookupStrategy)) {
                log.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(this.entityType.getName(), cacheLookupStrategy);
            }
            return result;
        }
    }
}

