/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.mapper.orm.model.impl.AbstractHibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassPropertyModel;
import org.hibernate.search.mapper.pojo.model.hcann.spi.PojoCommonsAnnotationsHelper;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class HibernateOrmClassRawTypeModel<T>
extends AbstractHibernateOrmRawTypeModel<T> {
    private final HibernateOrmBasicClassTypeMetadata ormTypeMetadata;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext;
    private List<HibernateOrmClassRawTypeModel<? super T>> ascendingSuperTypesCache;
    private List<HibernateOrmClassRawTypeModel<? super T>> descendingSuperTypesCache;
    private final Map<String, HibernateOrmClassPropertyModel<?>> propertyModelCache = new HashMap();
    private Map<String, XProperty> declaredFieldAccessXPropertiesByName;
    private Map<String, XProperty> declaredMethodAccessXPropertiesByName;

    HibernateOrmClassRawTypeModel(HibernateOrmBootstrapIntrospector introspector, PojoRawTypeIdentifier<T> typeIdentifier, HibernateOrmBasicClassTypeMetadata ormTypeMetadata, GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> rawTypeDeclaringContext) {
        super(introspector, typeIdentifier);
        this.ormTypeMetadata = ormTypeMetadata;
        this.rawTypeDeclaringContext = rawTypeDeclaringContext;
    }

    public boolean isAbstract() {
        return this.xClass.isAbstract();
    }

    @Override
    public boolean isSubTypeOf(MappableTypeModel superTypeCandidate) {
        return superTypeCandidate instanceof HibernateOrmClassRawTypeModel && ((HibernateOrmClassRawTypeModel)superTypeCandidate).xClass.isAssignableFrom(this.xClass);
    }

    @Override
    public Stream<HibernateOrmClassRawTypeModel<? super T>> getAscendingSuperTypes() {
        if (this.ascendingSuperTypesCache == null) {
            this.ascendingSuperTypesCache = this.introspector.getAscendingSuperTypes(this.xClass).collect(Collectors.toList());
        }
        return this.ascendingSuperTypesCache.stream();
    }

    @Override
    public Stream<HibernateOrmClassRawTypeModel<? super T>> getDescendingSuperTypes() {
        if (this.descendingSuperTypesCache == null) {
            this.descendingSuperTypesCache = this.introspector.getDescendingSuperTypes(this.xClass).collect(Collectors.toList());
        }
        return this.descendingSuperTypesCache.stream();
    }

    public Stream<Annotation> getAnnotations() {
        return this.introspector.getAnnotations((XAnnotatedElement)this.xClass);
    }

    @Override
    Stream<String> getDeclaredPropertyNames() {
        return Stream.concat(this.getDeclaredFieldAccessXPropertiesByName().keySet().stream(), this.getDeclaredMethodAccessXPropertiesByName().keySet().stream()).distinct();
    }

    @Override
    HibernateOrmClassPropertyModel<?> getPropertyOrNull(String propertyName) {
        return this.propertyModelCache.computeIfAbsent(propertyName, this::createPropertyModel);
    }

    GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<T> getRawTypeDeclaringContext() {
        return this.rawTypeDeclaringContext;
    }

    private Map<String, XProperty> getDeclaredFieldAccessXPropertiesByName() {
        if (this.declaredFieldAccessXPropertiesByName == null) {
            this.declaredFieldAccessXPropertiesByName = this.introspector.getDeclaredFieldAccessXPropertiesByName(this.xClass);
        }
        return this.declaredFieldAccessXPropertiesByName;
    }

    private Map<String, XProperty> getDeclaredMethodAccessXPropertiesByName() {
        if (this.declaredMethodAccessXPropertiesByName == null) {
            this.declaredMethodAccessXPropertiesByName = this.introspector.getDeclaredMethodAccessXPropertiesByName(this.xClass);
        }
        return this.declaredMethodAccessXPropertiesByName;
    }

    private HibernateOrmClassPropertyModel<?> createPropertyModel(String propertyName) {
        HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata;
        Member member;
        XProperty fieldAccessXProperty;
        ArrayList<XProperty> declaredXProperties = new ArrayList<XProperty>(2);
        XProperty methodAccessXProperty = this.getDeclaredMethodAccessXPropertiesByName().get(propertyName);
        if (methodAccessXProperty != null) {
            declaredXProperties.add(methodAccessXProperty);
        }
        if ((fieldAccessXProperty = this.getDeclaredFieldAccessXPropertiesByName().get(propertyName)) != null) {
            declaredXProperties.add(fieldAccessXProperty);
        }
        if ((member = this.findPropertyMember(propertyName, methodAccessXProperty, fieldAccessXProperty, ormPropertyMetadata = this.ormTypeMetadata == null ? null : this.ormTypeMetadata.getClassPropertyMetadataOrNull(propertyName))) == null) {
            return null;
        }
        return new HibernateOrmClassPropertyModel(this.introspector, this, propertyName, declaredXProperties, ormPropertyMetadata, member);
    }

    private Member findPropertyMember(String propertyName, XProperty methodAccessXProperty, XProperty fieldAccessXProperty, HibernateOrmBasicClassPropertyMetadata propertyMetadataFromHibernateOrmMetamodel) {
        if (propertyMetadataFromHibernateOrmMetamodel != null) {
            Member memberFromHibernateOrmMetamodel = propertyMetadataFromHibernateOrmMetamodel.getMember();
            if (memberFromHibernateOrmMetamodel instanceof Method) {
                return methodAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)methodAccessXProperty);
            }
            if (memberFromHibernateOrmMetamodel instanceof Field) {
                return fieldAccessXProperty == null ? memberFromHibernateOrmMetamodel : PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)fieldAccessXProperty);
            }
            return this.getPropertyMemberFromParentTypes(propertyName);
        }
        if (methodAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)methodAccessXProperty);
        }
        if (fieldAccessXProperty != null) {
            return PojoCommonsAnnotationsHelper.getUnderlyingMember((XProperty)fieldAccessXProperty);
        }
        return this.getPropertyMemberFromParentTypes(propertyName);
    }

    private Member getPropertyMemberFromParentTypes(String propertyName) {
        return this.getAscendingSuperTypes().skip(1L).map(type -> type.getPropertyOrNull(propertyName)).filter(Objects::nonNull).findFirst().map(HibernateOrmClassPropertyModel::getMember).orElse(null);
    }
}

