/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmMapperSpiSettings;
import org.hibernate.search.mapper.orm.cfg.spi.HibernateOrmReflectionStrategyName;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.model.impl.AbstractHibernateOrmRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmClassRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmGenericContextHelper;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeIdentifierResolver;
import org.hibernate.search.mapper.pojo.model.hcann.spi.AbstractPojoHCAnnBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.impl.ReflectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandleFactory;

public class HibernateOrmBootstrapIntrospector
extends AbstractPojoHCAnnBootstrapIntrospector
implements PojoBootstrapIntrospector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<HibernateOrmReflectionStrategyName> REFLECTION_STRATEGY = ConfigurationProperty.forKey((String)"reflection.strategy").as(HibernateOrmReflectionStrategyName.class, HibernateOrmReflectionStrategyName::of).withDefault((Object)HibernateOrmMapperSpiSettings.Defaults.REFLECTION_STRATEGY).build();
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final ValueReadHandleFactory valueReadHandleFactory;
    private final HibernateOrmGenericContextHelper genericContextHelper;
    private final GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext<?> missingRawTypeDeclaringContext;
    private final Map<Class<?>, HibernateOrmClassRawTypeModel<?>> classTypeModelCache = new HashMap();
    private final Map<String, HibernateOrmDynamicMapRawTypeModel> dynamicMapTypeModelCache = new HashMap<String, HibernateOrmDynamicMapRawTypeModel>();

    public static HibernateOrmBootstrapIntrospector create(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, ReflectionManager ormReflectionManager, ConfigurationPropertySource propertySource) {
        ValueReadHandleFactory valueReadHandleFactory;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        HibernateOrmReflectionStrategyName reflectionStrategyName = (HibernateOrmReflectionStrategyName)((Object)REFLECTION_STRATEGY.get(propertySource));
        switch (reflectionStrategyName) {
            case JAVA_LANG_REFLECT: {
                valueReadHandleFactory = ValueReadHandleFactory.usingJavaLangReflect();
                break;
            }
            case METHOD_HANDLE: {
                valueReadHandleFactory = ValueReadHandleFactory.usingMethodHandle((MethodHandles.Lookup)lookup);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected reflection strategy name: " + (Object)((Object)reflectionStrategyName));
            }
        }
        return new HibernateOrmBootstrapIntrospector(basicTypeMetadataProvider, ormReflectionManager, valueReadHandleFactory);
    }

    private HibernateOrmBootstrapIntrospector(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, ReflectionManager reflectionManager, ValueReadHandleFactory valueReadHandleFactory) {
        super(reflectionManager);
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.valueReadHandleFactory = valueReadHandleFactory;
        this.genericContextHelper = new HibernateOrmGenericContextHelper(this);
        this.missingRawTypeDeclaringContext = new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, Object.class);
    }

    public AbstractHibernateOrmRawTypeModel<?> getTypeModel(String name) {
        HibernateOrmBasicDynamicMapTypeMetadata dynamicMapTypeOrmMetadata = this.basicTypeMetadataProvider.getBasicDynamicMapTypeMetadata(name);
        if (dynamicMapTypeOrmMetadata != null) {
            return this.dynamicMapTypeModelCache.computeIfAbsent(name, this::createDynamicMapTypeModel);
        }
        PojoRawTypeIdentifier<?> typeIdentifier = this.basicTypeMetadataProvider.getTypeIdentifierResolver().resolveByJpaOrHibernateOrmEntityName(name);
        if (typeIdentifier != null) {
            return this.getTypeModel(typeIdentifier.getJavaClass());
        }
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>(this.basicTypeMetadataProvider.getKnownDynamicMapTypeNames());
        typeNames.addAll(this.basicTypeMetadataProvider.getTypeIdentifierResolver().getKnownJpaOrHibernateOrmEntityNames());
        throw log.unknownNamedType(name, typeNames);
    }

    public <T> HibernateOrmClassRawTypeModel<T> getTypeModel(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ReflectionHelper.getPrimitiveWrapperType(clazz);
        }
        return this.classTypeModelCache.computeIfAbsent(clazz, this::createClassTypeModel);
    }

    public <T> PojoGenericTypeModel<T> getGenericTypeModel(Class<T> clazz) {
        return this.missingRawTypeDeclaringContext.createGenericTypeModel(clazz);
    }

    public ValueReadHandleFactory getAnnotationValueReadHandleFactory() {
        return this.valueReadHandleFactory;
    }

    <T> Stream<HibernateOrmClassRawTypeModel<? super T>> getAscendingSuperTypes(XClass xClass) {
        return this.getAscendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    <T> Stream<HibernateOrmClassRawTypeModel<? super T>> getDescendingSuperTypes(XClass xClass) {
        return this.getDescendingSuperClasses(xClass).map(clazz -> this.getTypeModel((Class)clazz));
    }

    ValueReadHandle<?> createValueReadHandle(Member member, HibernateOrmBasicClassPropertyMetadata ormPropertyMetadata) throws IllegalAccessException {
        if (member instanceof Method) {
            Method method = (Method)member;
            HibernateOrmBootstrapIntrospector.setAccessible(method);
            return this.valueReadHandleFactory.createForMethod(method);
        }
        if (member instanceof Field) {
            Method bytecodeEnhancerReaderMethod;
            Field field = (Field)member;
            if (ormPropertyMetadata != null && !ormPropertyMetadata.isId() && (bytecodeEnhancerReaderMethod = HibernateOrmBootstrapIntrospector.getBytecodeEnhancerReaderMethod(field)) != null) {
                HibernateOrmBootstrapIntrospector.setAccessible(bytecodeEnhancerReaderMethod);
                return this.valueReadHandleFactory.createForMethod(bytecodeEnhancerReaderMethod);
            }
            HibernateOrmBootstrapIntrospector.setAccessible(field);
            return this.valueReadHandleFactory.createForField(field);
        }
        throw new AssertionFailure("Unexpected type for a " + Member.class.getName() + ": " + member);
    }

    private HibernateOrmDynamicMapRawTypeModel createDynamicMapTypeModel(String name) {
        HibernateOrmBasicDynamicMapTypeMetadata ormMetadata = this.basicTypeMetadataProvider.getBasicDynamicMapTypeMetadata(name);
        PojoRawTypeIdentifier<Map> typeIdentifier = HibernateOrmRawTypeIdentifierResolver.createDynamicMapTypeIdentifier(name);
        return new HibernateOrmDynamicMapRawTypeModel(this, typeIdentifier, ormMetadata);
    }

    private <T> HibernateOrmClassRawTypeModel<T> createClassTypeModel(Class<T> type) {
        HibernateOrmBasicClassTypeMetadata ormMetadataOrNull = this.basicTypeMetadataProvider.getBasicClassTypeMetadata(type);
        PojoRawTypeIdentifier<T> typeIdentifier = HibernateOrmRawTypeIdentifierResolver.createClassTypeIdentifier(type);
        return new HibernateOrmClassRawTypeModel<T>(this, typeIdentifier, ormMetadataOrNull, new GenericContextAwarePojoGenericTypeModel.RawTypeDeclaringContext((GenericContextAwarePojoGenericTypeModel.Helper)this.genericContextHelper, type));
    }

    private static void setAccessible(AccessibleObject member) {
        block2: {
            try {
                member.setAccessible(true);
            }
            catch (SecurityException se) {
                if (Modifier.isPublic(((Member)((Object)member)).getModifiers())) break block2;
                throw se;
            }
        }
    }

    private static Method getBytecodeEnhancerReaderMethod(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        if (!PersistentAttributeInterceptable.class.isAssignableFrom(declaringClass)) {
            return null;
        }
        try {
            return declaringClass.getDeclaredMethod("$$_hibernate_read_" + field.getName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Read method for enhanced field " + field + " is unexpectedly missing.", (Throwable)e);
        }
    }
}

