/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.Session;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MassIndexingNotifier {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final FailureHandler failureHandler;
    private final MassIndexingMonitor monitor;
    private final AtomicReference<RecordedEntityIndexingFailure> entityIndexingFirstFailure = new AtomicReference<Object>(null);
    private final LongAdder entityIndexingFailureCount = new LongAdder();

    MassIndexingNotifier(FailureHandler failureHandler, MassIndexingMonitor monitor) {
        this.failureHandler = failureHandler;
        this.monitor = monitor;
    }

    void notifyAddedTotalCount(long totalCount) {
        this.monitor.addToTotalCount(totalCount);
    }

    void notifyRunnableFailure(Exception exception, String operation) {
        FailureContext.Builder contextBuilder = FailureContext.builder();
        contextBuilder.throwable((Throwable)exception);
        contextBuilder.failingOperation((Object)operation);
        this.failureHandler.handle(contextBuilder.build());
    }

    void notifyEntitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    void notifyDocumentBuilt() {
        this.monitor.documentsBuilt(1L);
    }

    void notifyDocumentsAdded(int size) {
        this.monitor.documentsAdded(size);
    }

    <T> void notifyEntityIndexingFailure(HibernateOrmMassIndexingIndexedTypeContext<T> type, Session session, T entity, Throwable throwable) {
        RecordedEntityIndexingFailure recordedFailure = new RecordedEntityIndexingFailure(throwable);
        this.entityIndexingFirstFailure.compareAndSet(null, recordedFailure);
        this.entityIndexingFailureCount.increment();
        EntityIndexingFailureContext.Builder contextBuilder = EntityIndexingFailureContext.builder();
        contextBuilder.throwable(throwable);
        contextBuilder.failingOperation((Object)log.massIndexerIndexingInstance(type.getJpaEntityName()));
        EntityReference entityReference = this.extractReferenceOrSuppress(type, session, entity, throwable);
        if (entityReference != null) {
            contextBuilder.entityReference((Object)entityReference);
            recordedFailure.entityReference = entityReference;
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    void notifyIndexingCompletedSuccessfully() {
        this.monitor.indexingCompleted();
        SearchException entityIndexingException = this.createEntityIndexingExceptionOrNull();
        if (entityIndexingException != null) {
            throw entityIndexingException;
        }
    }

    void notifyIndexingCompletedWithInterruption() {
        log.interruptedBatchIndexing();
        this.notifyIndexingCompletedSuccessfully();
    }

    void notifyIndexingCompletedWithFailure(Throwable throwable) {
        this.monitor.indexingCompleted();
        SearchException entityIndexingException = this.createEntityIndexingExceptionOrNull();
        if (entityIndexingException != null) {
            throwable.addSuppressed((Throwable)entityIndexingException);
        }
        FailureContext.Builder contextBuilder = FailureContext.builder();
        contextBuilder.throwable(throwable);
        contextBuilder.failingOperation((Object)log.massIndexerOperation());
        this.failureHandler.handle(contextBuilder.build());
    }

    private SearchException createEntityIndexingExceptionOrNull() {
        RecordedEntityIndexingFailure firstFailure = this.entityIndexingFirstFailure.get();
        if (firstFailure == null) {
            return null;
        }
        return log.massIndexingEntityFailures(this.entityIndexingFailureCount.longValue(), firstFailure.entityReference, firstFailure.throwable.getMessage(), firstFailure.throwable);
    }

    private <T> EntityReference extractReferenceOrSuppress(HibernateOrmMassIndexingIndexedTypeContext<T> type, Session session, Object entity, Throwable throwable) {
        try {
            return new EntityReferenceImpl(type.getTypeIdentifier(), type.getJpaEntityName(), session.getIdentifier(entity));
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private static class RecordedEntityIndexingFailure {
        private Throwable throwable;
        private EntityReference entityReference;

        RecordedEntityIndexingFailure(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

