/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchCoordinator;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.monitor.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class MassIndexerImpl
implements MassIndexer {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final String THREAD_NAME_PREFIX = "Mass indexing - ";
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedBackendSessionContext sessionContext;
    private final Set<HibernateOrmMassIndexingIndexedTypeContext<?>> rootEntityTypes;
    private final PojoScopeWorkspace scopeWorkspace;
    private int typesToIndexInParallel = 1;
    private int documentBuilderThreads = 6;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeAtEnd = true;
    private boolean purgeAtStart = true;
    private boolean optimizeAfterPurge = true;
    private MassIndexingMonitor monitor;
    private int idFetchSize = 100;
    private Integer idLoadingTransactionTimeout;

    public MassIndexerImpl(HibernateOrmMassIndexingMappingContext mappingContext, Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> targetedIndexedTypes, DetachedBackendSessionContext sessionContext, PojoScopeWorkspace scopeWorkspace) {
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.rootEntityTypes = MassIndexerImpl.toRootEntityTypes(targetedIndexedTypes);
        this.scopeWorkspace = scopeWorkspace;
    }

    private static Set<HibernateOrmMassIndexingIndexedTypeContext<?>> toRootEntityTypes(Set<? extends HibernateOrmMassIndexingIndexedTypeContext<?>> targetedIndexedTypeContexts) {
        LinkedHashSet cleaned = new LinkedHashSet();
        HashSet<HibernateOrmMassIndexingIndexedTypeContext> toRemove = new HashSet<HibernateOrmMassIndexingIndexedTypeContext>();
        for (HibernateOrmMassIndexingIndexedTypeContext<?> typeContext : targetedIndexedTypeContexts) {
            EntityPersister entityPersister = typeContext.getEntityPersister();
            boolean typeIsOk = true;
            for (HibernateOrmMassIndexingIndexedTypeContext hibernateOrmMassIndexingIndexedTypeContext : cleaned) {
                EntityPersister existingEntityPersister = hibernateOrmMassIndexingIndexedTypeContext.getEntityPersister();
                if (HibernateOrmUtils.isSuperTypeOf(existingEntityPersister, entityPersister)) {
                    typeIsOk = false;
                    break;
                }
                if (!HibernateOrmUtils.isSuperTypeOf(entityPersister, existingEntityPersister)) continue;
                toRemove.add(hibernateOrmMassIndexingIndexedTypeContext);
            }
            if (!typeIsOk) continue;
            cleaned.add(typeContext);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }

    @Override
    public MassIndexer typesToIndexInParallel(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.typesToIndexInParallel = Math.min(numberOfThreads, this.rootEntityTypes.size());
        return this;
    }

    @Override
    public MassIndexer cacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            throw new IllegalArgumentException("cacheMode must not be null");
        }
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
        this.documentBuilderThreads = numberOfThreads;
        return this;
    }

    @Override
    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
        return this;
    }

    @Override
    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeAtEnd = optimize;
        return this;
    }

    @Override
    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    @Override
    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAtStart = purgeAll;
        return this;
    }

    @Override
    public MassIndexer transactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
        return this;
    }

    @Override
    public MassIndexer monitor(MassIndexingMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> start() {
        BatchCoordinator coordinator = this.createCoordinator();
        ThreadPoolExecutor executor = this.mappingContext.getThreadPoolProvider().newFixedThreadPool(1, "Mass indexing - Coordinator");
        try {
            CompletableFuture completableFuture = Futures.runAsync((Runnable)coordinator, (ExecutorService)executor);
            return completableFuture;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected BatchCoordinator createCoordinator() {
        MassIndexingNotifier notifier = new MassIndexingNotifier(this.mappingContext.getFailureHandler(), this.getOrCreateMonitor());
        return new BatchCoordinator(this.mappingContext, this.sessionContext, notifier, this.rootEntityTypes, this.scopeWorkspace, this.typesToIndexInParallel, this.documentBuilderThreads, this.cacheMode, this.objectLoadingBatchSize, this.objectsLimit, this.optimizeAtEnd, this.purgeAtStart, this.optimizeAfterPurge, this.idFetchSize, this.idLoadingTransactionTimeout);
    }

    @Override
    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.objectsLimit = maximum;
        return this;
    }

    @Override
    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }

    private MassIndexingMonitor getOrCreateMonitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        return new SimpleIndexingProgressMonitor();
    }
}

