/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoModelPathFormatter;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return "HSEARCH000027: Going to reindex %d entities";
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH000028: Reindexed %1$d entities";
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return "HSEARCH000030: %1$d documents indexed in %2$d ms";
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Mass indexing was interrupted";
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return "HSEARCH000065: Error while rolling back transaction after %1$s";
    }

    protected String massIndexerOperation$str() {
        return "MassIndexer operation";
    }

    @Override
    public final String massIndexerOperation() {
        return String.format(this.getLoggingLocale(), this.massIndexerOperation$str(), new Object[0]);
    }

    protected String massIndexerIndexingInstance$str() {
        return "Indexing instance of entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerIndexingInstance(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerIndexingInstance$str(), entityName);
    }

    protected String massIndexerFetchingIds$str() {
        return "Fetching identifiers of entities to index for entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexerFetchingIds(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexerFetchingIds$str(), entityName);
    }

    protected String massIndexingLoadingAndExtractingEntityData$str() {
        return "Loading and extracting entity data for entity '%s' during mass indexing";
    }

    @Override
    public final String massIndexingLoadingAndExtractingEntityData(String entityName) {
        return String.format(this.getLoggingLocale(), this.massIndexingLoadingAndExtractingEntityData$str(), entityName);
    }

    @Override
    public final void defaultAutomaticIndexingSynchronizationStrategy(Object strategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.defaultAutomaticIndexingSynchronizationStrategy$str(), strategy);
    }

    protected String defaultAutomaticIndexingSynchronizationStrategy$str() {
        return "HSEARCH000235: Default automatic indexing synchronization strategy set to '%s'.";
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction is active while indexing entity '%1$s'; Consider increasing the connection time-out";
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(String entityName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), entityName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedSearchHitEntityName$str() {
        return "HSEARCH800002: Unexpected entity name for a query hit: '%1$s'. Expected one of %2$s.";
    }

    @Override
    public final SearchException unexpectedSearchHitEntityName(String entityName, Collection<String> expectedNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedSearchHitEntityName$str(), entityName, expectedNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Path '%1$s' cannot be resolved to a persisted value in Hibernate ORM metadata. If this path points to a transient value, use @IndexingDependency(derivedFrom = ...) to specify which persisted values it is derived from. See the reference documentation for more information.";
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), new PojoModelPathFormatter(path)), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%2$s' that will never be reported as dirty by Hibernate ORM. Check that you didn't declare an invalid indexing dependency.";
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), new PojoModelPathFormatter(path), value));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Container value extractor with name '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindReadableProperty$str() {
        return "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    }

    @Override
    public final SearchException cannotFindReadableProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindReadableProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingThreadInterrupted$str() {
        return "HSEARCH800013: Mass indexing was interrupted; index will be left in unknown state!";
    }

    @Override
    public final SearchException massIndexingThreadInterrupted(InterruptedException e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingThreadInterrupted$str(), new Object[0]), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidReflectionStrategyName$str() {
        return "HSEARCH800015: Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidReflectionStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidReflectionStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Error trying to access Hibernate ORM session.";
    }

    @Override
    public final SearchException hibernateSessionAccessError(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session seems to be closed.";
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(String entityName, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)entityName, (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' will ignore the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(String entityName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)entityName);
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' will ignore the second-level cache  even though it was instructed to use it, because caching is not enabled for this entity type.";
    }

    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Error trying to access Hibernate ORM session factory.";
    }

    @Override
    public final SearchException hibernateSessionFactoryAccessError(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionFactoryAccessError$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }

    @Override
    public final SearchException indexingFailure(String causeMessage, List<EntityReference> failingEntities, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexingFailure$str(), causeMessage, failingEntities), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String automaticIndexing$str() {
        return "Automatic indexing of Hibernate ORM entities";
    }

    @Override
    public final String automaticIndexing() {
        return String.format(this.getLoggingLocale(), this.automaticIndexing$str(), new Object[0]);
    }

    protected String synchronizationBeforeTransactionFailure$str() {
        return "HSEARCH800023: Automatic indexing failed before transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationBeforeTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationBeforeTransactionFailure$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String synchronizationAfterTransactionFailure$str() {
        return "HSEARCH800024: Automatic indexing failed after transaction completion: %1$s";
    }

    @Override
    public final SearchException synchronizationAfterTransactionFailure(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.synchronizationAfterTransactionFailure$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingTransactionHandlingException$str() {
        return "HSEARCH800025: Exception while handling transactions: %1$s";
    }

    @Override
    public final SearchException massIndexingTransactionHandlingException(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingTransactionHandlingException$str(), causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String massIndexingEntityFailures$str() {
        return "HSEARCH800026: %1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s";
    }

    @Override
    public final SearchException massIndexingEntityFailures(long finalFailureCount, EntityReference firstFailureEntity, String firstFailureMessage, Throwable firstFailure) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.massIndexingEntityFailures$str(), finalFailureCount, firstFailureEntity, firstFailureMessage), firstFailure);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownNamedType$str() {
        return "HSEARCH800027: Unknown type: '%1$s'. Available named types: %2$s. For entity types, the correct type name is the entity name. For component types (embeddeds, ...) in dynamic-map entities, the correct type name is name of the owner entity followed by a dot ('.') followed by the dot-separated path to the component, e.g. 'MyEntity.myEmbedded' or 'MyEntity.myEmbedded.myNestedEmbedded'.";
    }

    @Override
    public final SearchException unknownNamedType(String typeName, Collection<String> availableNamedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNamedType$str(), typeName, availableNamedTypes));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEntityName$str() {
        return "HSEARCH800028: Unknown entity name: '%1$s'. Available entity names: %2$s.";
    }

    @Override
    public final SearchException invalidEntityName(String entityName, Collection<String> availableEntityNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntityName$str(), entityName, availableEntityNames));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidEntitySuperType$str() {
        return "HSEARCH800029: Invalid type for '%1$s': expected the entity to extend '%2$s', but entity type '%3$s' does not.";
    }

    @Override
    public final SearchException invalidEntitySuperType(String entityName, Class<?> expectedSuperType, Class<?> actualJavaType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidEntitySuperType$str(), entityName, new ClassFormatter(expectedSuperType), new ClassFormatter(actualJavaType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String nonJpaEntityType$str() {
        return "HSEARCH800030: Type '%1$s' doesn't have any representation in the JPA metamodel. As a result, Hibernate Search cannot use the Criteria API to automatically build queries targeting this type. This means in particular that this type cannot: 1) be mass-indexed or 2) set its document ID to a property that is not its entity ID.";
    }

    @Override
    public final SearchException nonJpaEntityType(PojoRawTypeIdentifier<?> typeIdentifier) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonJpaEntityType$str(), typeIdentifier));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

