/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationConfigurationContext;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class SearchableAutomaticIndexingSynchronizationStrategy
implements AutomaticIndexingSynchronizationStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final AutomaticIndexingSynchronizationStrategy INSTANCE = new SearchableAutomaticIndexingSynchronizationStrategy();

    private SearchableAutomaticIndexingSynchronizationStrategy() {
    }

    public String toString() {
        return AutomaticIndexingSynchronizationStrategy.class.getSimpleName() + ".searchable()";
    }

    @Override
    public void apply(AutomaticIndexingSynchronizationConfigurationContext context) {
        context.documentCommitStrategy(DocumentCommitStrategy.FORCE);
        context.documentRefreshStrategy(DocumentRefreshStrategy.FORCE);
        context.indexingFutureHandler(future -> {
            SearchIndexingPlanExecutionReport report = (SearchIndexingPlanExecutionReport)Futures.unwrappedExceptionJoin((CompletableFuture)future);
            report.getThrowable().ifPresent(t -> {
                throw log.indexingFailure(t.getMessage(), report.getFailingEntities(), (Throwable)t);
            });
        });
    }
}

