/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierProducer<E, I>
implements StatelessSessionAwareRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionFactory sessionFactory;
    private final MassIndexingNotifier notifier;
    private final String tenantId;
    private final ProducerConsumerQueue<List<I>> destination;
    private final int batchSize;
    private final Class<E> indexedType;
    private final String entityName;
    private final SingularAttribute<? super E, I> idAttributeOfIndexedType;
    private final long objectsLimit;
    private final int idFetchSize;

    IdentifierProducer(SessionFactory sessionFactory, String tenantId, MassIndexingNotifier notifier, ProducerConsumerQueue<List<I>> fromIdentifierListToEntities, int objectLoadingBatchSize, Class<E> indexedType, String entityName, SingularAttribute<? super E, I> idAttributeOfIndexedType, long objectsLimit, int idFetchSize) {
        this.sessionFactory = sessionFactory;
        this.tenantId = tenantId;
        this.notifier = notifier;
        this.destination = fromIdentifierListToEntities;
        this.batchSize = objectLoadingBatchSize;
        this.indexedType = indexedType;
        this.entityName = entityName;
        this.idAttributeOfIndexedType = idAttributeOfIndexedType;
        this.objectsLimit = objectsLimit;
        this.idFetchSize = idFetchSize;
        log.trace("created");
    }

    @Override
    public void run(StatelessSession upperSession) {
        log.trace("started");
        try {
            this.inTransactionWrapper(upperSession);
        }
        catch (RuntimeException exception) {
            this.notifier.notifyRunnableFailure(exception, log.massIndexerFetchingIds(this.entityName));
        }
        finally {
            this.destination.producerStopping();
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inTransactionWrapper(StatelessSession upperSession) {
        StatelessSession session = upperSession;
        if (upperSession == null) {
            session = this.tenantId == null ? this.sessionFactory.openStatelessSession() : this.sessionFactory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();
        }
        try {
            boolean controlTransactions;
            Transaction transaction = ((SharedSessionContractImplementor)session).accessTransaction();
            boolean bl = controlTransactions = !transaction.isActive();
            if (controlTransactions) {
                transaction.begin();
            }
            try {
                this.loadAllIdentifiers(session);
            }
            finally {
                if (controlTransactions) {
                    transaction.commit();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        long totalCount = (Long)this.createTotalCountQuery(session).uniqueResult();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        if (log.isDebugEnabled()) {
            log.debugf("going to fetch %d primary keys", totalCount);
        }
        this.notifier.notifyAddedTotalCount(totalCount);
        ArrayList<Object> destinationList = new ArrayList<Object>(this.batchSize);
        long counter = 0L;
        try (ScrollableResults results = this.createIdentifiersQuery(session).scroll(ScrollMode.FORWARD_ONLY);){
            while (results.next()) {
                Object id = results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    SharedSessionContractImplementor sessionImpl = (SharedSessionContractImplementor)session;
                    if (!sessionImpl.isTransactionInProgress()) {
                        throw log.transactionNotActiveWhileProducingIdsForBatchIndexing(this.indexedType);
                    }
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        this.enqueueList(destinationList);
    }

    private Query<Long> createTotalCountQuery(StatelessSession session) {
        CriteriaBuilder criteriaBuilder = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.indexedType);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        return session.createQuery(criteriaQuery).setCacheable(false);
    }

    private Query<I> createIdentifiersQuery(StatelessSession session) {
        CriteriaBuilder criteriaBuilder = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.idAttributeOfIndexedType.getJavaType());
        Root root = criteriaQuery.from(this.indexedType);
        Path idPath = root.get(this.idAttributeOfIndexedType);
        criteriaQuery.select((Selection)idPath);
        return session.createQuery(criteriaQuery).setCacheable(false).setFetchSize(this.idFetchSize);
    }

    private void enqueueList(List<I> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.tracef("produced a list of ids %s", idsList);
        }
    }
}

