/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.FailureHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace<E, I>
extends FailureHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedBackendSessionContext sessionContext;
    private final ProducerConsumerQueue<List<I>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<E> indexedType;
    private final String entityName;
    private final SingularAttribute<? super E, I> idAttributeOfIndexedType;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final List<CompletableFuture<?>> identifierProducingFutures = new ArrayList();
    private final List<CompletableFuture<?>> indexingFutures = new ArrayList();

    BatchIndexingWorkspace(HibernateOrmMassIndexingMappingContext mappingContext, DetachedBackendSessionContext sessionContext, MassIndexingNotifier notifier, Class<E> type, String entityName, SingularAttribute<? super E, I> idAttributeOfIndexedType, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, long objectsLimit, int idFetchSize, Integer transactionTimeout) {
        super(notifier);
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.indexedType = type;
        this.entityName = entityName;
        this.idAttributeOfIndexedType = idAttributeOfIndexedType;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.objectsLimit = objectsLimit;
    }

    @Override
    public void runWithFailureHandler() throws InterruptedException {
        if (!this.identifierProducingFutures.isEmpty() || !this.indexingFutures.isEmpty()) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused");
        }
        BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.mappingContext.getSessionFactory());
        this.startIndexing();
        this.startProducingPrimaryKeys(transactionalContext);
        Futures.unwrappedExceptionGet(CompletableFuture.allOf(this.indexingFutures.toArray(new CompletableFuture[0])));
        log.debugf("Indexing for %s is done", this.indexedType.getName());
    }

    @Override
    protected void cleanUpOnInterruption() {
        this.cancelPendingTasks();
    }

    @Override
    protected void cleanUpOnFailure() {
        this.cancelPendingTasks();
    }

    private void cancelPendingTasks() {
        for (Future future : this.identifierProducingFutures) {
            future.cancel(true);
        }
        for (Future future : this.indexingFutures) {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, this.getNotifier(), new IdentifierProducer<E, I>((SessionFactory)this.mappingContext.getSessionFactory(), this.sessionContext.getTenantIdentifier(), this.getNotifier(), this.primaryKeyStream, this.objectLoadingBatchSize, this.indexedType, this.entityName, this.idAttributeOfIndexedType, this.objectsLimit, this.idFetchSize), this.transactionTimeout, this.sessionContext.getTenantIdentifier());
        ThreadPoolExecutor identifierProducingExecutor = this.mappingContext.getThreadPoolProvider().newFixedThreadPool(1, "Mass indexing - " + this.entityName + " - ID loading");
        try {
            this.identifierProducingFutures.add(Futures.runAsync((Runnable)primaryKeyOutputter, (ExecutorService)identifierProducingExecutor));
        }
        finally {
            identifierProducingExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIndexing() {
        IdentifierConsumerDocumentProducer<? super E, I> documentOutputter = new IdentifierConsumerDocumentProducer<E, I>(this.mappingContext, this.sessionContext.getTenantIdentifier(), this.getNotifier(), this.primaryKeyStream, this.cacheMode, this.indexedType, this.entityName, this.idAttributeOfIndexedType, this.transactionTimeout);
        ThreadPoolExecutor indexingExecutor = this.mappingContext.getThreadPoolProvider().newFixedThreadPool(this.documentBuilderThreads, "Mass indexing - " + this.entityName + " - Entity loading");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                this.indexingFutures.add(Futures.runAsync(documentOutputter, (ExecutorService)indexingExecutor));
            }
        }
        finally {
            indexingExecutor.shutdown();
        }
    }
}

