/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private HibernateOrmUtils() {
    }

    public static SessionFactoryImplementor toSessionFactoryImplementor(EntityManagerFactory entityManagerFactory) {
        try {
            return (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionFactoryAccessError(e);
        }
    }

    public static SessionImplementor toSessionImplementor(EntityManager entityManager) {
        try {
            return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
    }
}

