/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.internal.ParameterMetadataImpl;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.spi.SearchQueryImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchQueryAdapterExtension;
import org.hibernate.search.mapper.orm.search.query.impl.HibernateOrmSearchScrollableResultsAdapter;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public final class HibernateOrmSearchQueryAdapter<R>
extends AbstractProducedQuery<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchQueryImplementor<R> delegate;
    private final MutableEntityLoadingOptions loadingOptions;
    private Integer firstResult;
    private Integer maxResults;

    public static <R> HibernateOrmSearchQueryAdapter<R> create(SearchQuery<R> query) {
        return (HibernateOrmSearchQueryAdapter)((Object)query.extension(HibernateOrmSearchQueryAdapterExtension.get()));
    }

    HibernateOrmSearchQueryAdapter(SearchQueryImplementor<R> delegate, SessionImplementor sessionImplementor, MutableEntityLoadingOptions loadingOptions) {
        super((SharedSessionContractImplementor)sessionImplementor, (ParameterMetadata)new ParameterMetadataImpl(null, null));
        this.delegate = delegate;
        this.loadingOptions = loadingOptions;
    }

    public String toString() {
        return "HibernateOrmSearchQueryAdapter(" + this.getQueryString() + ")";
    }

    public <T> T unwrap(Class<T> type) {
        if (type.equals(SearchQuery.class)) {
            return (T)this.delegate;
        }
        return (T)super.unwrap(type);
    }

    public List<R> list() {
        try {
            return this.doList();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
        catch (QueryException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public HibernateOrmSearchQueryAdapter<R> setMaxResults(int maxResults) {
        if ((long)maxResults < 0L) {
            throw new IllegalArgumentException("Negative (" + maxResults + ") parameter passed in to setMaxResults");
        }
        this.maxResults = maxResults;
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.firstResult = firstResult;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults == null ? Integer.MAX_VALUE : this.maxResults;
    }

    public int getFirstResult() {
        return this.firstResult == null ? 0 : this.firstResult;
    }

    public HibernateOrmSearchQueryAdapter<R> setFetchSize(int fetchSize) {
        this.loadingOptions.fetchSize(fetchSize);
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> setFlushMode(FlushModeType flushModeType) {
        super.setFlushMode(flushModeType);
        return this;
    }

    public String getQueryString() {
        return this.delegate.queryString();
    }

    public HibernateOrmSearchQueryAdapter<R> setHint(String hintName, Object value) {
        switch (hintName) {
            case "javax.persistence.query.timeout": {
                this.delegate.failAfter(HibernateOrmSearchQueryAdapter.hintValueToLong(value), TimeUnit.MILLISECONDS);
                break;
            }
            case "org.hibernate.timeout": {
                this.setTimeout(HibernateOrmSearchQueryAdapter.hintValueToInteger(value));
                break;
            }
            case "javax.persistence.fetchgraph": {
                this.applyGraph(HibernateOrmSearchQueryAdapter.hintValueToEntityGraph(value), GraphSemantic.FETCH);
                break;
            }
            case "javax.persistence.loadgraph": {
                this.applyGraph(HibernateOrmSearchQueryAdapter.hintValueToEntityGraph(value), GraphSemantic.LOAD);
                break;
            }
            default: {
                this.handleUnrecognizedHint(hintName, value);
            }
        }
        return this;
    }

    public HibernateOrmSearchQueryAdapter<R> setTimeout(int timeout) {
        this.delegate.failAfter((long)timeout, TimeUnit.SECONDS);
        return this;
    }

    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        this.loadingOptions.entityGraphHint(new EntityGraphHint(graph, semantic), true);
        return this;
    }

    public ScrollableResultsImplementor scroll() {
        return this.scroll(ScrollMode.FORWARD_ONLY);
    }

    public ScrollableResultsImplementor scroll(ScrollMode scrollMode) {
        if (!ScrollMode.FORWARD_ONLY.equals((Object)scrollMode)) {
            throw log.canOnlyUseScrollWithScrollModeForwardsOnly(scrollMode);
        }
        int chunkSize = this.loadingOptions.fetchSize();
        return new HibernateOrmSearchScrollableResultsAdapter(this.delegate.scroll(chunkSize), this.getMaxResults());
    }

    protected boolean isNativeQuery() {
        return false;
    }

    protected List<R> doList() {
        return this.delegate.fetchHits(this.firstResult, this.maxResults);
    }

    public Iterator<R> iterate() {
        throw new UnsupportedOperationException("iterate() is not implemented in Hibernate Search queries. Use scroll() instead.");
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <P> HibernateOrmSearchQueryAdapter<R> setParameter(Parameter<P> tParameter, P t) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(Parameter<Calendar> calendarParameter, Calendar calendar, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(Parameter<Date> dateParameter, Date date, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(String name, Object value) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(String name, Date value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(int position, Object value) {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(int position, Date value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public Set<Parameter<?>> getParameters() {
        return Collections.emptySet();
    }

    protected QueryParameterBindings getQueryParameterBindings() {
        throw this.parametersNoSupported();
    }

    public HibernateOrmSearchQueryAdapter<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        throw this.parametersNoSupported();
    }

    public QueryParameter<?> getParameter(String name) {
        throw this.parametersNoSupported();
    }

    public QueryParameter<?> getParameter(int position) {
        throw this.parametersNoSupported();
    }

    public <T> QueryParameter<T> getParameter(String name, Class<T> type) {
        throw this.parametersNoSupported();
    }

    public <T> QueryParameter<T> getParameter(int position, Class<T> type) {
        throw this.parametersNoSupported();
    }

    public boolean isBound(Parameter<?> param) {
        throw this.parametersNoSupported();
    }

    public <T> T getParameterValue(Parameter<T> param) {
        throw this.parametersNoSupported();
    }

    public Object getParameterValue(String name) {
        throw this.parametersNoSupported();
    }

    public Object getParameterValue(int position) {
        throw this.parametersNoSupported();
    }

    private UnsupportedOperationException parametersNoSupported() {
        return new UnsupportedOperationException("parameters not supported in Hibernate Search queries");
    }

    public HibernateOrmSearchQueryAdapter<R> setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Deprecated
    public HibernateOrmSearchQueryAdapter<R> setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        throw this.resultTransformerNotImplemented();
    }

    private UnsupportedOperationException resultTransformerNotImplemented() {
        return new UnsupportedOperationException("Result transformers are not supported in Hibernate Search queries");
    }

    public HibernateOrmSearchQueryAdapter<R> setLockMode(LockModeType lockModeType) {
        throw new UnsupportedOperationException("lock modes not supported in Hibernate Search queries");
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("lock modes not supported in Hibernate Search queries");
    }

    public LockOptions getLockOptions() {
        return null;
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public HibernateOrmSearchQueryAdapter<R> setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Deprecated
    public Type[] getReturnTypes() {
        throw new UnsupportedOperationException("getReturnTypes() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public String[] getReturnAliases() {
        throw new UnsupportedOperationException("getReturnAliases() is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public HibernateOrmSearchQueryAdapter<R> setEntity(int position, Object val) {
        throw new UnsupportedOperationException("setEntity(int,Object) is not implemented in Hibernate Search queries");
    }

    @Deprecated
    public HibernateOrmSearchQueryAdapter<R> setEntity(String name, Object val) {
        throw new UnsupportedOperationException("setEntity(String,Object) is not implemented in Hibernate Search queries");
    }

    private static long hintValueToLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(String.valueOf(value));
    }

    private static int hintValueToInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(String.valueOf(value));
    }

    private static RootGraph<?> hintValueToEntityGraph(Object value) {
        return (RootGraph)value;
    }
}

