/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingConfigurationContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapperDelegate;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMetatadaContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMappingPartialBuildState>
implements HibernateOrmMappingConfigurationContext {
    private static final ConfigurationProperty<Boolean> MAPPING_PROCESS_ANNOTATIONS = ConfigurationProperty.forKey((String)"mapping.process_annotations").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends HibernateOrmSearchMappingConfigurer>> MAPPING_CONFIGURER = ConfigurationProperty.forKey((String)"mapping.configurer").asBeanReference(HibernateOrmSearchMappingConfigurer.class).build();
    private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
    private final HibernateOrmBootstrapIntrospector introspector;

    public static HibernateOrmMappingInitiator create(Metadata metadata, ReflectionManager reflectionManager, ConfigurationService ormConfigurationService, ConfigurationPropertySource propertySource) {
        HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider = HibernateOrmBasicTypeMetadataProvider.create(metadata);
        HibernateOrmBootstrapIntrospector introspector = HibernateOrmBootstrapIntrospector.create(basicTypeMetadataProvider, reflectionManager, propertySource);
        return new HibernateOrmMappingInitiator(basicTypeMetadataProvider, ormConfigurationService, introspector);
    }

    private HibernateOrmMappingInitiator(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider, ConfigurationService ormConfigurationService, HibernateOrmBootstrapIntrospector introspector) {
        super((PojoBootstrapIntrospector)introspector);
        this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        this.introspector = introspector;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy((Map)ormConfigurationService.getSettings());
        this.multiTenancyEnabled(!MultiTenancyStrategy.NONE.equals((Object)multiTenancyStrategy));
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        ConfigurationPropertySource propertySource = buildContext.configurationPropertySource();
        this.addConfigurationContributor(new HibernateOrmMetatadaContributor(this.basicTypeMetadataProvider, this.introspector));
        boolean processAnnotations = (Boolean)MAPPING_PROCESS_ANNOTATIONS.get(propertySource);
        if (processAnnotations) {
            this.annotatedTypeDiscoveryEnabled(true);
            AnnotationMappingConfigurationContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass : this.basicTypeMetadataProvider.getPersistentClasses()) {
                if (!persistentClass.hasPojoRepresentation()) continue;
                annotationMapping.add(persistentClass.getMappedClass());
            }
        }
        BeanResolver beanResolver = buildContext.beanResolver();
        MAPPING_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
            try (BeanHolder configurerHolder = holder;){
                ((HibernateOrmSearchMappingConfigurer)configurerHolder.get()).configure(this);
            }
        });
        super.configure(buildContext, configurationCollector);
    }

    protected PojoMapperDelegate<HibernateOrmMappingPartialBuildState> createMapperDelegate() {
        return new HibernateOrmMapperDelegate(this.basicTypeMetadataProvider);
    }
}

