/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;
import org.hibernate.search.mapper.orm.mapping.context.HibernateOrmMappingContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.orm.schema.management.impl.SchemaManagementListener;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmMapping
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements SearchMapping,
HibernateOrmMappingContext,
HibernateOrmListenerContextProvider,
HibernateOrmScopeMappingContext,
HibernateOrmSearchSessionMappingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<BeanReference<? extends AutomaticIndexingSynchronizationStrategy>> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.synchronization.strategy").asBeanReference(AutomaticIndexingSynchronizationStrategy.class).withDefault(HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY).build();
    private static final ConfigurationProperty<EntityLoadingCacheLookupStrategy> QUERY_LOADING_CACHE_LOOKUP_STRATEGY = ConfigurationProperty.forKey((String)"query.loading.cache_lookup.strategy").as(EntityLoadingCacheLookupStrategy.class, EntityLoadingCacheLookupStrategy::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.QUERY_LOADING_CACHE_LOOKUP_STRATEGY).build();
    private static final ConfigurationProperty<Integer> QUERY_LOADING_FETCH_SIZE = ConfigurationProperty.forKey((String)"query.loading.fetch_size").asInteger().withDefault((Object)100).build();
    private static final ConfigurationProperty<SchemaManagementStrategyName> SCHEMA_MANAGEMENT_STRATEGY = ConfigurationProperty.forKey((String)"schema_management.strategy").as(SchemaManagementStrategyName.class, SchemaManagementStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.SCHEMA_MANAGEMENT_STRATEGY).build();
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateOrmTypeContextContainer typeContextContainer;
    private final BeanHolder<? extends AutomaticIndexingSynchronizationStrategy> defaultSynchronizationStrategyHolder;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;
    private final int fetchSize;
    private final SchemaManagementListener schemaManagementListener;

    public static MappingImplementor<HibernateOrmMapping> create(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, ConfigurationPropertySource propertySource, BeanResolver beanResolver) {
        BeanHolder synchronizationStrategyHolder = (BeanHolder)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
        try {
            log.defaultAutomaticIndexingSynchronizationStrategy(synchronizationStrategyHolder.get());
            EntityLoadingCacheLookupStrategy cacheLookupStrategy = (EntityLoadingCacheLookupStrategy)((Object)QUERY_LOADING_CACHE_LOOKUP_STRATEGY.get(propertySource));
            int fetchSize = (Integer)QUERY_LOADING_FETCH_SIZE.get(propertySource);
            SchemaManagementStrategyName schemaManagementStrategyName = (SchemaManagementStrategyName)((Object)SCHEMA_MANAGEMENT_STRATEGY.get(propertySource));
            SchemaManagementListener schemaManagementListener = new SchemaManagementListener(schemaManagementStrategyName);
            return new HibernateOrmMapping(mappingDelegate, typeContextContainer, sessionFactory, (BeanHolder<? extends AutomaticIndexingSynchronizationStrategy>)synchronizationStrategyHolder, cacheLookupStrategy, fetchSize, schemaManagementListener);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)synchronizationStrategyHolder);
            throw e;
        }
    }

    private HibernateOrmMapping(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, BeanHolder<? extends AutomaticIndexingSynchronizationStrategy> defaultSynchronizationStrategyHolder, EntityLoadingCacheLookupStrategy cacheLookupStrategy, int fetchSize, SchemaManagementListener schemaManagementListener) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.sessionFactory = sessionFactory;
        this.defaultSynchronizationStrategyHolder = defaultSynchronizationStrategyHolder;
        this.cacheLookupStrategy = cacheLookupStrategy;
        this.fetchSize = fetchSize;
        this.schemaManagementListener = schemaManagementListener;
    }

    public CompletableFuture<?> start(MappingStartContext context) {
        Optional<SearchScopeImpl<Object>> scope = this.createAllScope();
        if (!scope.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        PojoScopeSchemaManager schemaManager = scope.get().schemaManagerDelegate();
        return this.schemaManagementListener.onStart(context, schemaManager);
    }

    public CompletableFuture<?> preStop(MappingPreStopContext context) {
        Optional<SearchScopeImpl<Object>> scope = this.createAllScope();
        if (!scope.isPresent()) {
            return CompletableFuture.completedFuture(null);
        }
        PojoScopeSchemaManager schemaManager = scope.get().schemaManagerDelegate();
        return this.schemaManagementListener.onStop(context, schemaManager);
    }

    protected void doStop() {
        this.defaultSynchronizationStrategyHolder.close();
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        return this.createScope(types);
    }

    @Override
    public <T> SearchScope<T> scope(Class<T> expectedSuperType, Collection<String> entityNames) {
        return this.createScope(expectedSuperType, entityNames);
    }

    @Override
    public EntityManagerFactory toEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public SessionFactory toOrmSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SearchIndexedEntity indexedEntity(Class<?> entityType) {
        PojoRawTypeIdentifier<?> typeIdentifier = this.typeContextContainer.typeIdentifierForJavaClass(entityType);
        HibernateOrmScopeIndexedTypeContext type = this.typeContextContainer.indexedForExactType((PojoRawTypeIdentifier)typeIdentifier);
        if (type == null) {
            throw log.notIndexedEntityType(entityType);
        }
        return type;
    }

    @Override
    public SearchIndexedEntity indexedEntity(String entityName) {
        PojoRawTypeIdentifier<?> typeIdentifier = this.typeContextContainer.typeIdentifierForEntityName(entityName);
        HibernateOrmScopeIndexedTypeContext type = this.typeContextContainer.indexedForExactType((PojoRawTypeIdentifier)typeIdentifier);
        if (type == null) {
            throw log.notIndexedEntityName(entityName);
        }
        return type;
    }

    public Collection<SearchIndexedEntity> allIndexedEntities() {
        return Collections.unmodifiableCollection(this.typeContextContainer.allIndexed());
    }

    @Override
    public IndexManager indexManager(String indexName) {
        return this.searchIntegration().indexManager(indexName);
    }

    @Override
    public Backend backend() {
        return this.searchIntegration().backend();
    }

    @Override
    public Backend backend(String backendName) {
        return this.searchIntegration().backend(backendName);
    }

    public HibernateOrmMapping toConcreteType() {
        return this;
    }

    @Override
    public PojoIndexer createIndexer(SessionImplementor sessionImplementor) {
        return HibernateOrmSearchSession.get(this, sessionImplementor).createIndexer();
    }

    @Override
    public EntityLoadingCacheLookupStrategy cacheLookupStrategy() {
        return this.cacheLookupStrategy;
    }

    @Override
    public int fetchSize() {
        return this.fetchSize;
    }

    @Override
    public SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public ThreadPoolProvider threadPoolProvider() {
        return this.delegate().threadPoolProvider();
    }

    @Override
    public FailureHandler failureHandler() {
        return this.delegate().failureHandler();
    }

    @Override
    public HibernateOrmScopeSessionContext sessionContext(EntityManager entityManager) {
        return HibernateOrmSearchSession.get(this, HibernateOrmUtils.toSessionImplementor(entityManager));
    }

    @Override
    public DetachedBackendSessionContext detachedBackendSessionContext(String tenantId) {
        return DetachedBackendSessionContext.of((BackendMappingContext)this, (String)tenantId);
    }

    @Override
    public PojoIndexingPlan<EntityReference> currentIndexingPlan(SessionImplementor session, boolean createIfDoesNotExist) {
        return HibernateOrmSearchSession.get(this, session).currentIndexingPlan(createIfDoesNotExist);
    }

    @Override
    public ConfiguredAutomaticIndexingSynchronizationStrategy currentAutomaticIndexingSynchronizationStrategy(SessionImplementor session) {
        return HibernateOrmSearchSession.get(this, session).configuredAutomaticIndexingSynchronizationStrategy();
    }

    @Override
    public HibernateOrmTypeContextContainer typeContextProvider() {
        return this.typeContextContainer;
    }

    @Override
    public <T> SearchScopeImpl<T> createScope(Collection<? extends Class<? extends T>> classes) {
        ArrayList<PojoRawTypeIdentifier<T>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<T>>(classes.size());
        for (Class<T> clazz : classes) {
            typeIdentifiers.add(this.typeContextContainer.typeIdentifierForJavaClass(clazz));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    @Override
    public <T> SearchScopeImpl<T> createScope(Class<T> expectedSuperType, Collection<String> entityNames) {
        ArrayList<PojoRawTypeIdentifier<T>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<T>>(entityNames.size());
        for (String entityName : entityNames) {
            typeIdentifiers.add(this.entityTypeIdentifier(expectedSuperType, entityName));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    @Override
    public HibernateOrmSearchSession.Builder createSessionBuilder(SessionImplementor sessionImplementor) {
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals(this.sessionFactory)) {
            throw log.usingDifferentSessionFactories((SessionFactory)this.sessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchSession.Builder(this, this.typeContextContainer, sessionImplementor, (AutomaticIndexingSynchronizationStrategy)this.defaultSynchronizationStrategyHolder.get());
    }

    private SearchIntegration searchIntegration() {
        return HibernateSearchContextProviderService.get(this.sessionFactory()).getIntegration();
    }

    private <T> PojoRawTypeIdentifier<? extends T> entityTypeIdentifier(Class<T> expectedSuperType, String entityName) {
        PojoRawTypeIdentifier<?> typeIdentifier = this.typeContextContainer.typeIdentifierForEntityName(entityName);
        Class actualJavaType = typeIdentifier.javaClass();
        if (!expectedSuperType.isAssignableFrom(actualJavaType)) {
            throw log.invalidEntitySuperType(entityName, expectedSuperType, actualJavaType);
        }
        PojoRawTypeIdentifier<?> castedTypeIdentifier = typeIdentifier;
        return castedTypeIdentifier;
    }

    private Optional<SearchScopeImpl<Object>> createAllScope() {
        return this.delegate().createPojoAllScope((PojoScopeMappingContext)this, this.typeContextContainer::indexedForExactType).map(scopeDelegate -> new SearchScopeImpl(this, scopeDelegate));
    }

    private <T> SearchScopeImpl<T> doCreateScope(Collection<PojoRawTypeIdentifier<? extends T>> typeIdentifiers) {
        PojoScopeDelegate scopeDelegate = this.delegate().createPojoScope((PojoScopeMappingContext)this, typeIdentifiers, this.typeContextContainer::indexedForExactType);
        return new SearchScopeImpl(this, scopeDelegate);
    }
}

