/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private HibernateOrmUtils() {
    }

    public static SessionFactoryImplementor toSessionFactoryImplementor(EntityManagerFactory entityManagerFactory) {
        try {
            return (SessionFactoryImplementor)entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionFactoryAccessError(e);
        }
    }

    public static SessionImplementor toSessionImplementor(EntityManager entityManager) {
        try {
            return (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
    }

    public static boolean isSuperTypeOf(EntityPersister type1, EntityPersister type2) {
        return type1.isSubclassEntityName(type2.getEntityName());
    }

    public static EntityPersister toRootEntityType(SessionFactoryImplementor sessionFactory, EntityPersister entityType) {
        MetamodelImplementor metamodel = sessionFactory.getMetamodel();
        String rootEntityName = entityType.getRootEntityName();
        return metamodel.entityPersister(rootEntityName);
    }

    public static EntityPersister toMostSpecificCommonEntitySuperType(MetamodelImplementor metamodel, EntityPersister type1, EntityPersister type2) {
        EntityPersister superTypeCandidate = type1;
        while (superTypeCandidate != null && !HibernateOrmUtils.isSuperTypeOf(superTypeCandidate, type2)) {
            String superSuperTypeEntityName = superTypeCandidate.getEntityMetamodel().getSuperclass();
            superTypeCandidate = superSuperTypeEntityName == null ? null : metamodel.entityPersister(superSuperTypeEntityName).getEntityPersister();
        }
        if (superTypeCandidate == null) {
            throw new AssertionFailure("Cannot find a common entity supertype for " + type1.getEntityName() + " and " + type2.getEntityName() + ". There is a bug in Hibernate Search, please report it.");
        }
        return superTypeCandidate;
    }

    public static Query<?> createQueryForLoadByUniqueProperty(SessionImplementor session, EntityPersister persister, String uniquePropertyName, String parameterName) {
        MetamodelImplementor metamodel = session.getSessionFactory().getMetamodel();
        EntityTypeDescriptor typeDescriptorOrNull = metamodel.entity(persister.getEntityName());
        if (typeDescriptorOrNull != null) {
            return HibernateOrmUtils.createQueryForLoadByUniqueProperty(session, typeDescriptorOrNull, uniquePropertyName, parameterName);
        }
        return session.createQuery("select e from " + persister.getEntityName() + " e where " + uniquePropertyName + " in (:" + parameterName + ")", persister.getMappedClass());
    }

    private static <E> Query<E> createQueryForLoadByUniqueProperty(SessionImplementor session, EntityTypeDescriptor<E> typeDescriptor, String uniquePropertyName, String parameterName) {
        CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
        ParameterExpression idsParameter = criteriaBuilder.parameter(Collection.class, parameterName);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(typeDescriptor.getJavaType());
        Root root = criteriaQuery.from(typeDescriptor);
        Path uniquePropertyInRoot = root.get(typeDescriptor.getSingularAttribute(uniquePropertyName));
        criteriaQuery.where((Expression)uniquePropertyInRoot.in(new Expression[]{idsParameter}));
        return session.createQuery(criteriaQuery);
    }
}

