/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.mapper.orm.bootstrap.impl.ExtendedBeanManagerSynchronizer;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmBeanContainerBeanProvider;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingInitiator;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingKey;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextProviderService;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class HibernateOrmIntegrationBooterImpl
implements HibernateOrmIntegrationBooter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<HibernateOrmIntegrationPartialBuildState> INTEGRATION_PARTIAL_BUILD_STATE = ConfigurationProperty.forKey((String)"hibernate.search.integration_partial_build_state").as(HibernateOrmIntegrationPartialBuildState.class, HibernateOrmIntegrationPartialBuildState::parse).build();
    private final Metadata metadata;
    private final ServiceRegistryImplementor serviceRegistry;
    private final ReflectionManager reflectionManager;
    private final ConfigurationService ormConfigurationService;
    private final ConfigurationPropertySource rootPropertySource;
    private final ConfigurationPropertyChecker propertyChecker;
    private final Optional<EnvironmentSynchronizer> environmentSynchronizer;

    static ConfigurationPropertySource getPropertySource(ServiceRegistry serviceRegistry, ConfigurationPropertyChecker propertyChecker) {
        return propertyChecker.wrap(ConfigurationPropertySource.fromMap((Map)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings()));
    }

    public HibernateOrmIntegrationBooterImpl(Metadata metadata, BootstrapContext bootstrapContext) {
        this(metadata, bootstrapContext, ConfigurationPropertyChecker.create());
    }

    private HibernateOrmIntegrationBooterImpl(Metadata metadata, BootstrapContext bootstrapContext, ConfigurationPropertyChecker propertyChecker) {
        this(metadata, bootstrapContext, HibernateOrmIntegrationBooterImpl.getPropertySource((ServiceRegistry)bootstrapContext.getServiceRegistry(), propertyChecker), propertyChecker);
    }

    HibernateOrmIntegrationBooterImpl(Metadata metadata, BootstrapContext bootstrapContext, ConfigurationPropertySource checkerWrappedPropertySource, ConfigurationPropertyChecker propertyChecker) {
        this.metadata = metadata;
        this.serviceRegistry = (ServiceRegistryImplementor)bootstrapContext.getServiceRegistry();
        this.reflectionManager = bootstrapContext.getReflectionManager();
        this.rootPropertySource = checkerWrappedPropertySource;
        this.propertyChecker = propertyChecker;
        this.ormConfigurationService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        Optional<EnvironmentSynchronizer> providedEnvironmentSynchronizer = this.getOrmServiceOrEmpty(EnvironmentSynchronizer.class);
        if (providedEnvironmentSynchronizer.isPresent()) {
            this.environmentSynchronizer = providedEnvironmentSynchronizer;
        } else {
            Object unknownBeanManager = this.ormConfigurationService.getSettings().get("javax.persistence.bean.manager");
            if (unknownBeanManager instanceof ExtendedBeanManager) {
                ExtendedBeanManager extendedBeanManager = (ExtendedBeanManager)unknownBeanManager;
                ExtendedBeanManagerSynchronizer synchronizer = new ExtendedBeanManagerSynchronizer();
                extendedBeanManager.registerLifecycleListener((ExtendedBeanManager.LifecycleListener)synchronizer);
                this.environmentSynchronizer = Optional.of(synchronizer);
            } else {
                this.environmentSynchronizer = Optional.empty();
            }
        }
    }

    @Override
    public void preBoot(BiConsumer<String, Object> propertyCollector) {
        if (this.environmentSynchronizer.isPresent()) {
            throw new AssertionFailure("Cannot pre-boot when an environment synchronizer is used to delay Hibernate Search's bootstrap:  we cannot both delay bootstrap and perform it earlier.");
        }
        HibernateOrmIntegrationPartialBuildState partialBuildState = this.doBootFirstPhase();
        propertyCollector.accept("hibernate.search.integration_partial_build_state", partialBuildState);
    }

    CompletableFuture<HibernateSearchContextProviderService> orchestrateBootAndShutdown(CompletionStage<SessionFactoryImplementor> sessionFactoryReadyStage, CompletionStage<?> sessionFactoryDestroyingStage) {
        CompletableFuture<HibernateSearchContextProviderService> contextFuture = new CompletableFuture<HibernateSearchContextProviderService>();
        CompletableFuture environmentSynchronizerReadyStage = new CompletableFuture();
        CompletableFuture environmentSynchronizerStartedDestroyingStage = new CompletableFuture();
        if (this.environmentSynchronizer.isPresent()) {
            this.environmentSynchronizer.get().whenEnvironmentDestroying(() -> environmentSynchronizerStartedDestroyingStage.complete(null));
            this.environmentSynchronizer.get().whenEnvironmentReady(() -> {
                environmentSynchronizerReadyStage.complete(null);
                if (contextFuture.isCompletedExceptionally()) {
                    Futures.unwrappedExceptionJoin((CompletableFuture)contextFuture);
                }
            });
        } else {
            environmentSynchronizerReadyStage.complete(null);
        }
        CompletionStage bootRequiredStage = environmentSynchronizerReadyStage.thenCombine(sessionFactoryReadyStage, (ignored, sessionFactory) -> sessionFactory);
        CompletableFuture<Object> shutdownRequiredStage = CompletableFuture.anyOf(environmentSynchronizerStartedDestroyingStage, sessionFactoryDestroyingStage.toCompletableFuture());
        ((CompletableFuture)((CompletableFuture)bootRequiredStage).thenApply(this::bootNow)).whenComplete(Futures.copyHandler(contextFuture));
        shutdownRequiredStage.thenRun(() -> HibernateOrmIntegrationBooterImpl.lambda$orchestrateBootAndShutdown$3((CompletableFuture)bootRequiredStage));
        ((CompletableFuture)((CompletableFuture)contextFuture.exceptionally(throwable -> null)).thenAcceptBoth(shutdownRequiredStage, (context, ignored) -> {
            if (context != null) {
                context.close();
            }
        })).whenComplete(Futures.handler((ignored, throwable) -> {
            if (throwable != null) {
                log.shutdownFailed(throwable.getMessage(), (Throwable)throwable);
            }
        }));
        return contextFuture;
    }

    private HibernateSearchContextProviderService bootNow(SessionFactoryImplementor sessionFactoryImplementor) {
        Optional partialBuildStateOptional = (Optional)INTEGRATION_PARTIAL_BUILD_STATE.get(this.rootPropertySource);
        HibernateOrmIntegrationPartialBuildState partialBuildState = partialBuildStateOptional.isPresent() ? (HibernateOrmIntegrationPartialBuildState)partialBuildStateOptional.get() : this.doBootFirstPhase();
        try {
            return this.doBootSecondPhase(partialBuildState, sessionFactoryImplementor);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(HibernateOrmIntegrationPartialBuildState::closeOnFailure, (Object)partialBuildState);
            throw e;
        }
    }

    private HibernateOrmIntegrationPartialBuildState doBootFirstPhase() {
        ReflectionBeanProvider reflectionBeanProvider = null;
        Object beanProvider = null;
        SearchIntegrationPartialBuildState searchIntegrationPartialBuildState = null;
        try {
            BeanContainer beanContainer;
            SearchIntegrationBuilder builder = SearchIntegration.builder((ConfigurationPropertySource)this.rootPropertySource, (ConfigurationPropertyChecker)this.propertyChecker);
            HibernateOrmMappingKey mappingKey = new HibernateOrmMappingKey();
            HibernateOrmMappingInitiator mappingInitiator = HibernateOrmMappingInitiator.create(this.metadata, this.reflectionManager, this.ormConfigurationService, builder.maskedPropertySource());
            builder.addMappingInitiator((MappingKey)mappingKey, (MappingInitiator)mappingInitiator);
            ClassLoaderService hibernateOrmClassLoaderService = this.getOrmServiceOrFail(ClassLoaderService.class);
            Optional<ManagedBeanRegistry> managedBeanRegistryService = this.getOrmServiceOrEmpty(ManagedBeanRegistry.class);
            HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver classAndResourceAndServiceResolver = new HibernateOrmClassLoaderServiceClassAndResourceAndServiceResolver(hibernateOrmClassLoaderService);
            builder.classResolver((ClassResolver)classAndResourceAndServiceResolver);
            builder.resourceResolver((ResourceResolver)classAndResourceAndServiceResolver);
            builder.serviceResolver((ServiceResolver)classAndResourceAndServiceResolver);
            reflectionBeanProvider = ReflectionBeanProvider.create((ClassResolver)classAndResourceAndServiceResolver);
            if (managedBeanRegistryService.isPresent() && (beanContainer = managedBeanRegistryService.get().getBeanContainer()) != null) {
                beanProvider = new HibernateOrmBeanContainerBeanProvider(beanContainer, reflectionBeanProvider);
            }
            if (beanProvider == null) {
                beanProvider = reflectionBeanProvider;
            }
            builder.beanProvider((BeanProvider)beanProvider);
            searchIntegrationPartialBuildState = builder.prepareBuild();
            return new HibernateOrmIntegrationPartialBuildState(searchIntegrationPartialBuildState, mappingKey);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser((Throwable)e).push(SearchIntegrationPartialBuildState::closeOnFailure, searchIntegrationPartialBuildState)).push(BeanProvider::close, reflectionBeanProvider)).push(BeanProvider::close, beanProvider);
            throw e;
        }
    }

    private HibernateSearchContextProviderService doBootSecondPhase(HibernateOrmIntegrationPartialBuildState partialBuildState, SessionFactoryImplementor sessionFactoryImplementor) {
        SearchIntegrationFinalizer finalizer = partialBuildState.integrationBuildState.finalizer(this.rootPropertySource, this.propertyChecker);
        HibernateOrmMapping mapping = (HibernateOrmMapping)finalizer.finalizeMapping((MappingKey)partialBuildState.mappingKey, (context, partialMapping) -> partialMapping.bindToSessionFactory(context, sessionFactoryImplementor));
        SearchIntegration integration = finalizer.finalizeIntegration();
        HibernateSearchContextProviderService contextService = (HibernateSearchContextProviderService)sessionFactoryImplementor.getServiceRegistry().getService(HibernateSearchContextProviderService.class);
        contextService.initialize(integration, mapping);
        return contextService;
    }

    private <T extends Service> T getOrmServiceOrFail(Class<T> serviceClass) {
        Service service = this.serviceRegistry.getService(serviceClass);
        if (service == null) {
            throw new AssertionFailure("A required service was missing; there is probably a bug in Hibernate ORM or Hibernate Search. Missing service: " + serviceClass);
        }
        return (T)service;
    }

    private <T extends Service> Optional<T> getOrmServiceOrEmpty(Class<T> serviceClass) {
        ServiceBinding binding = this.serviceRegistry.locateServiceBinding(serviceClass);
        if (binding == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.serviceRegistry.getService(serviceClass));
    }

    private static /* synthetic */ void lambda$orchestrateBootAndShutdown$3(CompletableFuture bootRequiredStage) {
        bootRequiredStage.cancel(false);
    }

    private static final class HibernateOrmIntegrationPartialBuildState {
        private final SearchIntegrationPartialBuildState integrationBuildState;
        private final HibernateOrmMappingKey mappingKey;

        static HibernateOrmIntegrationPartialBuildState parse(String stringToParse) {
            throw new AssertionFailure("The partial build state cannot be parsed from a String; it must be null or an instance of " + HibernateOrmIntegrationPartialBuildState.class);
        }

        HibernateOrmIntegrationPartialBuildState(SearchIntegrationPartialBuildState integrationBuildState, HibernateOrmMappingKey mappingKey) {
            this.integrationBuildState = integrationBuildState;
            this.mappingKey = mappingKey;
        }

        void closeOnFailure() {
            this.integrationBuildState.closeOnFailure();
        }
    }
}

