/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.transaction.Synchronization;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class InTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingPlan indexingPlan;
    private final Map<?, ?> indexingPlanPerTransaction;
    private final Object transactionIdentifier;
    private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    public InTransactionWorkQueueSynchronization(PojoIndexingPlan indexingPlan, Map<?, ?> indexingPlanPerTransaction, Object transactionIdentifier, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlan = indexingPlan;
        this.indexingPlanPerTransaction = indexingPlanPerTransaction;
        this.transactionIdentifier = transactionIdentifier;
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void beforeCompletion() {
        try {
            log.tracef("Processing Transaction's beforeCompletion() phase for %s. Performing work.", this);
            CompletableFuture future = this.indexingPlan.execute();
            this.synchronizationStrategy.handleFuture(future);
        }
        finally {
            this.indexingPlanPerTransaction.remove(this.transactionIdentifier);
        }
    }

    public void afterCompletion(int status) {
    }
}

