/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class ErrorHandledRunnable
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ErrorHandler errorHandler;

    protected ErrorHandledRunnable(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final void run() {
        try {
            this.runWithErrorHandler();
        }
        catch (Exception re) {
            try {
                this.cleanUpOnError();
            }
            catch (RuntimeException e) {
                re.addSuppressed(e);
            }
            String errorMessage = log.massIndexerUnexpectedErrorMessage();
            this.errorHandler.handleException(errorMessage, (Throwable)re);
        }
    }

    protected abstract void runWithErrorHandler() throws Exception;

    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void cleanUpOnError() {
    }
}

