/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.SessionFactory;
import org.hibernate.mapping.Value;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.pojo.logging.spi.PojoTypeModelFormatter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return "HSEARCH000027: Going to reindex %d entities";
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return "HSEARCH000028: Reindexed %1$d entities";
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return "HSEARCH000030: %1$d documents indexed in %2$d ms";
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return "HSEARCH000031: Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return "HSEARCH000036: Cannot guess the Transaction Status: not starting a JTA transaction";
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return "HSEARCH000062: Batch indexing was interrupted";
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return "HSEARCH000065: Error while rolling back transaction after %1$s";
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return "HSEARCH000116: Unexpected error during MassIndexer operation";
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        return String.format(this.getLoggingLocale(), this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
    }

    protected String massIndexerUnableToIndexInstance$str() {
        return "HSEARCH000183: Unable to index instance of type %s while batch indexing: %s";
    }

    @Override
    public final String massIndexerUnableToIndexInstance(String clazz, String value) {
        return String.format(this.getLoggingLocale(), this.massIndexerUnableToIndexInstance$str(), clazz, value);
    }

    protected String massIndexerExceptionWhileFetchingIds$str() {
        return "HSEARCH000211: An exception occurred while the MassIndexer was fetching the primary identifiers list";
    }

    @Override
    public final String massIndexerExceptionWhileFetchingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileFetchingIds$str(), new Object[0]);
    }

    protected String massIndexerExceptionWhileTransformingIds$str() {
        return "HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents";
    }

    @Override
    public final String massIndexerExceptionWhileTransformingIds() {
        return String.format(this.getLoggingLocale(), this.massIndexerExceptionWhileTransformingIds$str(), new Object[0]);
    }

    protected String transactionNotActiveWhileProducingIdsForBatchIndexing$str() {
        return "HSEARCH000276: No transaction is active while indexing entity type '%1$s'; Consider increasing the connection time-out";
    }

    @Override
    public final SearchException transactionNotActiveWhileProducingIdsForBatchIndexing(Class<?> entityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.transactionNotActiveWhileProducingIdsForBatchIndexing$str(), new ClassFormatter(entityType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String hibernateSearchNotInitialized$str() {
        return "HSEARCH800001: Hibernate Search was not initialized.";
    }

    @Override
    public final SearchException hibernateSearchNotInitialized() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSearchNotInitialized$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedSearchHitType$str() {
        return "HSEARCH800002: Unexpected entity type for a query hit: %1$s. Expected one of %2$s.";
    }

    @Override
    public final SearchException unexpectedSearchHitType(Class<?> entityType, Collection<? extends Class<?>> expectedTypes) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedSearchHitType$str(), entityType, expectedTypes));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAutomaticIndexingStrategyName$str() {
        return "HSEARCH800003: Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownPathForDirtyChecking$str() {
        return "HSEARCH800007: Path '%2$s' on entity type '%1$s' cannot be resolved using Hibernate ORM metadata. Please check that this path points to a persisted value.";
    }

    @Override
    public final SearchException unknownPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownPathForDirtyChecking$str(), entityType, path), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unreportedPathForDirtyChecking$str() {
        return "HSEARCH800008: Path '%2$s' on entity type '%1$s' can be resolved using Hibernate ORM metadata, but points to value '%3$s' that will never be reported as dirty by Hibernate ORM. Please check that this path points to a persisted value, and in particular not an embedded property.";
    }

    @Override
    public final SearchException unreportedPathForDirtyChecking(Class<?> entityType, PojoModelPath path, Value value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unreportedPathForDirtyChecking$str(), entityType, path, value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContainerExtractorForDirtyChecking$str() {
        return "HSEARCH800009: Container value extractor with name '%2$s' cannot be applied to Hibernate ORM metadata node of type '%1$s'.";
    }

    @Override
    public final SearchException invalidContainerExtractorForDirtyChecking(Class<?> ormMappingClass, String extractorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidContainerExtractorForDirtyChecking$str(), ormMappingClass, extractorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindReadableProperty$str() {
        return "HSEARCH800010: Unable to find a readable property '%2$s' on type '%1$s'.";
    }

    @Override
    public final SearchException cannotFindReadableProperty(PojoRawTypeModel<?> typeModel, String propertyName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindReadableProperty$str(), new PojoTypeModelFormatter(typeModel), propertyName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String usingDifferentSessionFactories$str() {
        return "HSEARCH800011: Mapping service cannot create a SearchSession using a different session factory. Expected: '%1$s'. In use: '%2$s'.";
    }

    @Override
    public final SearchException usingDifferentSessionFactories(SessionFactory expectedSessionFactory, SessionFactory usedSessionFactory) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.usingDifferentSessionFactories$str(), expectedSessionFactory, usedSessionFactory));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorRetrievingPropertyTypeModel$str() {
        return "HSEARCH800012: Exception while retrieving property type model for '%1$s' on '%2$s'.";
    }

    @Override
    public final SearchException errorRetrievingPropertyTypeModel(String propertyModelName, PojoRawTypeModel<?> parentTypeModel, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.errorRetrievingPropertyTypeModel$str(), propertyModelName, new PojoTypeModelFormatter(parentTypeModel)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interruptedBatchIndexingException$str() {
        return "HSEARCH800013: Interrupted on batch Indexing; index will be left in unknown state!";
    }

    @Override
    public final SearchException interruptedBatchIndexingException(Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interruptedBatchIndexingException$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidReflectionStrategyName$str() {
        return "HSEARCH800015: Invalid reflection strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidReflectionStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidReflectionStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hibernateSessionAccessError$str() {
        return "HSEARCH800016: Error trying to access Hibernate ORM session.";
    }

    @Override
    public final SearchException hibernateSessionAccessError(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionAccessError$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String hibernateSessionIsClosed$str() {
        return "HSEARCH800017: Underlying Hibernate ORM Session seems to be closed.";
    }

    @Override
    public final SearchException hibernateSessionIsClosed(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionIsClosed$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAutomaticIndexingSynchronizationStrategyName$str() {
        return "HSEARCH800018: Invalid automatic indexing synchronization strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidAutomaticIndexingSynchronizationStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidAutomaticIndexingSynchronizationStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader(Class<?> entityType, EntityLoadingCacheLookupStrategy cacheLookupStrategy) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str(), (Object)new ClassFormatter(entityType), (Object)cacheLookupStrategy);
    }

    protected String skippingPreliminaryCacheLookupsForNonEntityIdEntityLoader$str() {
        return "HSEARCH800019: The entity loader for '%1$s' will ignore the cache lookup strategy '%2$s', because document IDs are distinct from entity IDs and thus cannot be used for persistence context or second level cache lookups.";
    }

    @Override
    public final void skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(Class<?> entityType) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str(), (Object)new ClassFormatter(entityType));
    }

    protected String skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader$str() {
        return "HSEARCH800020: The entity loader for '%1$s' will ignore the second-level cache  even though it was instructed to use it, because caching is not enabled for this entity type.";
    }

    protected String hibernateSessionFactoryAccessError$str() {
        return "HSEARCH800021: Error trying to access Hibernate ORM session factory.";
    }

    @Override
    public final SearchException hibernateSessionFactoryAccessError(IllegalStateException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.hibernateSessionFactoryAccessError$str(), new Object[0]), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

