/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.ReferenceHitMapper;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.common.impl.EntityReferenceImpl;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.scope.impl.SearchScopeImpl;
import org.hibernate.search.mapper.orm.search.SearchScope;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hibernate.search.mapper.orm.session.SearchSessionWritePlan;
import org.hibernate.search.mapper.orm.session.context.impl.HibernateOrmSessionContextImpl;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.session.impl.InTransactionWorkQueueSynchronization;
import org.hibernate.search.mapper.orm.session.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.mapper.orm.session.impl.SearchSessionWritePlanImpl;
import org.hibernate.search.mapper.orm.session.impl.SynchronizationAdapter;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.AbstractPojoSearchSession;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.TransientReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmSearchSession
extends AbstractPojoSearchSession
implements SearchSession,
HibernateOrmScopeSessionContext,
ReferenceHitMapper<EntityReference> {
    private static final String SEARCH_SESSION_KEY = HibernateOrmMapping.class.getName() + "#SEARCH_SESSION_KEY";
    private static final String WORK_PLAN_PER_TRANSACTION_MAP_KEY = HibernateOrmSearchSession.class.getName() + "#WORK_PLAN_PER_TRANSACTION_KEY";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmScopeMappingContext scopeMappingContext;
    private final HibernateOrmSessionTypeContextProvider typeContextProvider;
    private final HibernateOrmSessionContextImpl sessionContext;
    private AutomaticIndexingSynchronizationStrategy synchronizationStrategy;
    private boolean enlistInTransaction = false;
    private SearchSessionWritePlanImpl writePlan;

    public static HibernateOrmSearchSession get(HibernateOrmSearchSessionMappingContext context, SessionImplementor sessionImplementor) {
        HibernateOrmSearchSession searchSession;
        HibernateOrmSearchSession.checkOrmSessionIsOpen(sessionImplementor);
        TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
        HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
        if (searchSession == null) {
            searchSession = context.createSessionBuilder(sessionImplementor).build();
            reference = new TransientReference((Object)searchSession);
            sessionImplementor.setProperty(SEARCH_SESSION_KEY, (Object)reference);
            sessionImplementor.getEventListenerManager().addListener(new SessionEventListener[]{new SearchSessionClosingListener(sessionImplementor)});
        }
        return searchSession;
    }

    private HibernateOrmSearchSession(HibernateOrmSearchSessionBuilder builder) {
        this(builder, builder.buildSessionContext());
    }

    private HibernateOrmSearchSession(HibernateOrmSearchSessionBuilder builder, HibernateOrmSessionContextImpl sessionContext) {
        super((AbstractPojoSearchSession.AbstractBuilder)builder, (AbstractPojoSessionContextImplementor)sessionContext);
        this.scopeMappingContext = builder.scopeMappingContext;
        this.typeContextProvider = builder.typeContextProvider;
        this.sessionContext = sessionContext;
        this.synchronizationStrategy = builder.synchronizationStrategy;
    }

    public void close() {
    }

    @Override
    public EntityManager toEntityManager() {
        return this.sessionContext.getSession();
    }

    @Override
    public Session toOrmSession() {
        return this.sessionContext.getSession();
    }

    @Override
    public <T> SearchScope<T> scope(Collection<? extends Class<? extends T>> types) {
        this.checkOrmSessionIsOpen();
        PojoScopeDelegate scopeDelegate = this.getDelegate().createPojoScope(types, this.typeContextProvider::getIndexedByExactClass);
        return new SearchScopeImpl(this.scopeMappingContext, this, scopeDelegate);
    }

    @Override
    public SearchSessionWritePlan writePlan() {
        if (this.writePlan == null) {
            this.writePlan = new SearchSessionWritePlanImpl(this);
        }
        return this.writePlan;
    }

    @Override
    public void setAutomaticIndexingSynchronizationStrategy(AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.synchronizationStrategy = synchronizationStrategy;
    }

    @Override
    public SessionImplementor getSession() {
        return this.sessionContext.getSession();
    }

    @Override
    public DetachedSessionContextImplementor getDetachedSessionContext() {
        return DetachedSessionContextImplementor.of((SessionContextImplementor)this.sessionContext);
    }

    @Override
    public ReferenceHitMapper<EntityReference> getReferenceHitMapper() {
        return this;
    }

    public EntityReference fromDocumentReference(DocumentReference reference) {
        HibernateOrmSessionIndexedTypeContext typeContext = this.typeContextProvider.getByIndexName(reference.getIndexName());
        if (typeContext == null) {
            throw new AssertionFailure("Document reference " + reference + " refers to an unknown index");
        }
        Object id = typeContext.getIdentifierMapping().fromDocumentIdentifier(reference.getId(), (AbstractPojoSessionContextImplementor)this.sessionContext);
        return new EntityReferenceImpl(typeContext.getJavaClass(), id);
    }

    public PojoSessionWorkExecutor createSessionWorkExecutor(DocumentCommitStrategy commitStrategy) {
        return this.getDelegate().createSessionWorkExecutor(commitStrategy);
    }

    public PojoWorkPlan getCurrentWorkPlan(boolean createIfDoesNotExist) {
        PojoWorkPlan workPlan;
        HashMap<Transaction, PojoWorkPlan> workPlanPerTransaction;
        SessionImplementor sessionImplementor = this.sessionContext.getSession();
        Transaction transactionIdentifier = null;
        TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(WORK_PLAN_PER_TRANSACTION_MAP_KEY);
        HashMap<Transaction, PojoWorkPlan> hashMap = workPlanPerTransaction = reference == null ? null : (HashMap<Transaction, PojoWorkPlan>)reference.get();
        if (workPlanPerTransaction == null) {
            workPlanPerTransaction = new HashMap<Transaction, PojoWorkPlan>();
            reference = new TransientReference(workPlanPerTransaction);
            sessionImplementor.setProperty(WORK_PLAN_PER_TRANSACTION_MAP_KEY, (Object)reference);
        }
        if (sessionImplementor.isTransactionInProgress()) {
            transactionIdentifier = sessionImplementor.accessTransaction();
        }
        if ((workPlan = (PojoWorkPlan)workPlanPerTransaction.get(transactionIdentifier)) != null) {
            return workPlan;
        }
        if (!createIfDoesNotExist) {
            return null;
        }
        AutomaticIndexingSynchronizationStrategy workPlanSynchronizationStrategy = this.synchronizationStrategy;
        workPlan = this.createWorkPlan(workPlanSynchronizationStrategy.getDocumentCommitStrategy(), workPlanSynchronizationStrategy.getDocumentRefreshStrategy());
        workPlanPerTransaction.put(transactionIdentifier, workPlan);
        if (sessionImplementor.isTransactionInProgress()) {
            Synchronization txSync = this.createTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, workPlanSynchronizationStrategy);
            this.registerSynchronization(sessionImplementor, txSync);
        }
        return workPlan;
    }

    AutomaticIndexingSynchronizationStrategy getAutomaticIndexingSynchronizationStrategy() {
        return this.synchronizationStrategy;
    }

    private PojoWorkPlan createWorkPlan(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.getDelegate().createWorkPlan(commitStrategy, refreshStrategy);
    }

    private Synchronization createTransactionWorkQueueSynchronization(PojoWorkPlan workPlan, Map<Transaction, PojoWorkPlan> workPlanPerTransaction, Transaction transactionIdentifier, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        if (this.enlistInTransaction) {
            return new InTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
        }
        return new PostTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
    }

    private void registerSynchronization(SessionImplementor sessionImplementor, Synchronization synchronization) {
        ActionQueue actionQueue = sessionImplementor.getActionQueue();
        SynchronizationAdapter adapter = new SynchronizationAdapter(synchronization);
        boolean isLocal = this.isLocalTransaction(sessionImplementor);
        if (isLocal) {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
        } else {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
            sessionImplementor.accessTransaction().registerSynchronization((Synchronization)adapter);
        }
        actionQueue.registerProcess((AfterTransactionCompletionProcess)adapter);
    }

    private boolean isLocalTransaction(SessionImplementor sessionImplementor) {
        return !sessionImplementor.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
    }

    void checkOrmSessionIsOpen() {
        HibernateOrmSearchSession.checkOrmSessionIsOpen(this.sessionContext.getSession());
    }

    static void checkOrmSessionIsOpen(SessionImplementor session) {
        try {
            session.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
    }

    private static class SearchSessionClosingListener
    extends BaseSessionEventListener {
        private final SessionImplementor sessionImplementor;

        private SearchSessionClosingListener(SessionImplementor sessionImplementor) {
            this.sessionImplementor = sessionImplementor;
        }

        public void end() {
            HibernateOrmSearchSession searchSession;
            TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
            HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
            if (searchSession != null) {
                searchSession.close();
            }
        }
    }

    public static class HibernateOrmSearchSessionBuilder
    extends AbstractPojoSearchSession.AbstractBuilder<HibernateOrmSearchSession> {
        private final HibernateOrmMappingContextImpl mappingContext;
        private final HibernateOrmScopeMappingContext scopeMappingContext;
        private final HibernateOrmSessionTypeContextProvider typeContextProvider;
        private final SessionImplementor sessionImplementor;
        private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;

        public HibernateOrmSearchSessionBuilder(PojoMappingDelegate mappingDelegate, HibernateOrmMappingContextImpl mappingContext, HibernateOrmScopeMappingContext scopeMappingContext, HibernateOrmSessionTypeContextProvider typeContextProvider, SessionImplementor sessionImplementor, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
            super(mappingDelegate);
            this.mappingContext = mappingContext;
            this.scopeMappingContext = scopeMappingContext;
            this.typeContextProvider = typeContextProvider;
            this.sessionImplementor = sessionImplementor;
            this.synchronizationStrategy = synchronizationStrategy;
        }

        private HibernateOrmSessionContextImpl buildSessionContext() {
            return new HibernateOrmSessionContextImpl(this.mappingContext, this.sessionImplementor);
        }

        public HibernateOrmSearchSession build() {
            return new HibernateOrmSearchSession(this);
        }
    }
}

