/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.scope.impl;

import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.search.dsl.query.HibernateOrmSearchQueryHitTypeStep;
import org.hibernate.search.mapper.orm.search.dsl.query.impl.HibernateOrmSearchQueryHitTypeStepImpl;
import org.hibernate.search.mapper.orm.search.loading.context.impl.HibernateOrmLoadingContext;
import org.hibernate.search.mapper.orm.writing.SearchWriter;
import org.hibernate.search.mapper.orm.writing.impl.SearchWriterImpl;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;

public class SearchScopeImpl<E>
implements SearchScope<E>,
org.hibernate.search.mapper.orm.search.SearchScope<E> {
    private final HibernateOrmScopeMappingContext mappingContext;
    private final HibernateOrmScopeSessionContext sessionContext;
    private final PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate;

    public SearchScopeImpl(HibernateOrmScopeMappingContext mappingContext, HibernateOrmScopeSessionContext sessionContext, PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate) {
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.delegate = delegate;
    }

    @Override
    public HibernateOrmSearchQueryHitTypeStep<E> search() {
        HibernateOrmLoadingContext.Builder loadingContextBuilder = new HibernateOrmLoadingContext.Builder(this.mappingContext, this.sessionContext, this.delegate.getIncludedIndexedTypes());
        return new HibernateOrmSearchQueryHitTypeStepImpl(this.delegate.search(loadingContextBuilder), loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactory<EntityReference, E> projection() {
        return this.delegate.projection();
    }

    @Override
    public SearchWriter writer() {
        return new SearchWriterImpl(this.delegate.executor());
    }

    @Override
    public MassIndexer massIndexer() {
        return new MassIndexerImpl(this.sessionContext.getSession().getFactory(), this.mappingContext, this.delegate.getIncludedIndexedTypes(), this.sessionContext.getDetachedSessionContext(), this.delegate.executor());
    }
}

