/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.event.impl.EventsHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.event.impl.InitializingHibernateSearchState;
import org.hibernate.search.mapper.orm.event.impl.OptimalEventsHibernateSearchState;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateSearchEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
AutoFlushEventListener,
ClearEventListener {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final boolean dirtyCheckingEnabled;
    private volatile EventsHibernateSearchState state;

    public HibernateSearchEventListener(CompletableFuture<? extends HibernateOrmListenerContextProvider> contextProviderFuture, boolean dirtyCheckingEnabled) {
        this.state = new InitializingHibernateSearchState((CompletableFuture<HibernateOrmListenerContextProvider>)contextProviderFuture.thenApply(this::doInitialize));
        this.dirtyCheckingEnabled = dirtyCheckingEnabled;
    }

    public void onPostDelete(PostDeleteEvent event) {
        Object entity;
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, entity = event.getEntity());
        if (typeContext != null) {
            Object providedId = typeContext.toWorkPlanProvidedId(event.getId());
            this.getCurrentWorkPlan(contextProvider, (SessionImplementor)event.getSession()).delete(providedId, entity);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity;
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, entity = event.getEntity());
        if (typeContext != null) {
            Object providedId = typeContext.toWorkPlanProvidedId(event.getId());
            this.getCurrentWorkPlan(contextProvider, (SessionImplementor)event.getSession()).add(providedId, entity);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity;
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, entity = event.getEntity());
        if (typeContext != null) {
            PojoWorkPlan workPlan = this.getCurrentWorkPlan(contextProvider, (SessionImplementor)event.getSession());
            Object providedId = typeContext.toWorkPlanProvidedId(event.getId());
            if (this.dirtyCheckingEnabled) {
                workPlan.update(providedId, entity, this.getDirtyPropertyNames(event));
            } else {
                workPlan.update(providedId, entity);
            }
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        EventSource session = event.getSession();
        PojoWorkPlan currentWorkPlan = this.getCurrentWorkPlan(contextProvider, (SessionImplementor)session);
        currentWorkPlan.prepare();
        if (!session.isTransactionInProgress()) {
            AutomaticIndexingSynchronizationStrategy synchronizationStrategy = contextProvider.getSynchronizationStrategy();
            synchronizationStrategy.handleFuture(currentWorkPlan.execute());
        }
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        this.getCurrentWorkPlan(this.state.getContextProvider(), (SessionImplementor)event.getSession()).prepare();
    }

    public void onClear(ClearEvent event) {
        EventSource session = event.getSession();
        PojoWorkPlan workPlan = this.getCurrentWorkPlanIfExisting(this.state.getContextProvider(), (SessionImplementor)session);
        if (workPlan != null) {
            workPlan.clearNotPrepared();
        }
    }

    private HibernateOrmListenerContextProvider doInitialize(HibernateOrmListenerContextProvider contextProvider) {
        log.debug("Hibernate Search dirty checks " + (this.dirtyCheckingEnabled ? "enabled" : "disabled"));
        this.state = new OptimalEventsHibernateSearchState(contextProvider);
        return contextProvider;
    }

    private PojoWorkPlan getCurrentWorkPlan(HibernateOrmListenerContextProvider contextProvider, SessionImplementor sessionImplementor) {
        return contextProvider.getCurrentWorkPlan(sessionImplementor, true);
    }

    private PojoWorkPlan getCurrentWorkPlanIfExisting(HibernateOrmListenerContextProvider contextProvider, SessionImplementor sessionImplementor) {
        return contextProvider.getCurrentWorkPlan(sessionImplementor, false);
    }

    private HibernateOrmListenerTypeContext getTypeContext(HibernateOrmListenerContextProvider contextProvider, Object entity) {
        return contextProvider.getTypeContext(Hibernate.getClass((Object)entity));
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        HibernateOrmListenerContextProvider contextProvider = this.state.getContextProvider();
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        HibernateOrmListenerTypeContext typeContext = this.getTypeContext(contextProvider, entity);
        if (typeContext != null) {
            PojoWorkPlan workPlan = this.getCurrentWorkPlan(contextProvider, (SessionImplementor)event.getSession());
            Object providedId = typeContext.toWorkPlanProvidedId(event.getAffectedOwnerIdOrNull());
            if (this.dirtyCheckingEnabled) {
                PersistentCollection persistentCollection = event.getCollection();
                String collectionRole = null;
                if (persistentCollection != null) {
                    collectionRole = persistentCollection.getRole();
                }
                if (collectionRole != null) {
                    workPlan.update(providedId, entity, new String[]{collectionRole});
                } else {
                    workPlan.update(providedId, entity);
                }
            } else {
                workPlan.update(providedId, entity);
            }
        }
    }

    public String[] getDirtyPropertyNames(PostUpdateEvent event) {
        EntityPersister persister = event.getPersister();
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length > 0) {
            String[] propertyNames = persister.getPropertyNames();
            int length = dirtyProperties.length;
            String[] dirtyPropertyNames = new String[length];
            for (int i = 0; i < length; ++i) {
                dirtyPropertyNames[i] = propertyNames[dirtyProperties[i]];
            }
            return dirtyPropertyNames;
        }
        return EMPTY_STRING_ARRAY;
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }
}

