/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationPropertySource;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmMappingConfigurationContext;
import org.hibernate.search.mapper.orm.mapping.HibernateOrmSearchMappingConfigurer;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapperDelegate;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingPartialBuildState;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMetatadaContributor;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.AnnotationMappingConfigurationContext;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingInitiator;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.util.common.impl.StreamHelper;

public class HibernateOrmMappingInitiator
extends AbstractPojoMappingInitiator<HibernateOrmMappingPartialBuildState>
implements HibernateOrmMappingConfigurationContext {
    private static final ConfigurationProperty<Boolean> ENABLE_ANNOTATION_MAPPING = ConfigurationProperty.forKey((String)"enable_annotation_mapping").asBoolean().withDefault((Object)true).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends HibernateOrmSearchMappingConfigurer>> MAPPING_CONFIGURER = ConfigurationProperty.forKey((String)"mapping_configurer").asBeanReference(HibernateOrmSearchMappingConfigurer.class).build();
    private final Metadata metadata;
    private final ConfigurationPropertySource propertySource;
    private final HibernateOrmBootstrapIntrospector introspector;

    public static HibernateOrmMappingInitiator create(Metadata metadata, ReflectionManager reflectionManager, HibernateOrmConfigurationPropertySource propertySource) {
        HibernateOrmBootstrapIntrospector introspector = HibernateOrmBootstrapIntrospector.create(metadata, reflectionManager, propertySource);
        return new HibernateOrmMappingInitiator(metadata, propertySource, introspector);
    }

    private HibernateOrmMappingInitiator(Metadata metadata, HibernateOrmConfigurationPropertySource propertySource, HibernateOrmBootstrapIntrospector introspector) {
        super((PojoBootstrapIntrospector)introspector);
        this.metadata = metadata;
        this.propertySource = propertySource;
        this.introspector = introspector;
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(propertySource.getAllRawProperties());
        this.setMultiTenancyEnabled(!MultiTenancyStrategy.NONE.equals((Object)multiTenancyStrategy));
    }

    public void configure(MappingBuildContext buildContext, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        Map persistentClasses = (Map)this.metadata.getEntityBindings().stream().filter(persistentClass -> persistentClass.getMappedClass() != null).collect(StreamHelper.toMap(PersistentClass::getEntityName, Function.identity(), TreeMap::new));
        this.addConfigurationContributor(new HibernateOrmMetatadaContributor(this.introspector, persistentClasses));
        boolean enableAnnotationMapping = (Boolean)ENABLE_ANNOTATION_MAPPING.get(this.propertySource);
        if (enableAnnotationMapping) {
            this.setAnnotatedTypeDiscoveryEnabled(true);
            AnnotationMappingConfigurationContext annotationMapping = this.annotationMapping();
            for (PersistentClass persistentClass2 : persistentClasses.values()) {
                annotationMapping.add(persistentClass2.getMappedClass());
            }
        }
        BeanResolver beanResolver = buildContext.getBeanResolver();
        MAPPING_CONFIGURER.getAndMap(this.propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).ifPresent(holder -> {
            try (BeanHolder configurerHolder = holder;){
                ((HibernateOrmSearchMappingConfigurer)configurerHolder.get()).configure(this);
            }
        });
        super.configure(buildContext, configurationCollector);
    }

    protected PojoMapperDelegate<HibernateOrmMappingPartialBuildState> createMapperDelegate() {
        return new HibernateOrmMapperDelegate();
    }
}

