/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import javax.persistence.EntityManager;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmAutomaticIndexingSynchronizationStrategyName;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.context.impl.HibernateOrmMappingContextImpl;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmTypeContextContainer;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.TransientReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmMapping
extends AbstractPojoMappingImplementor<HibernateOrmMapping>
implements HibernateOrmScopeMappingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<HibernateOrmAutomaticIndexingSynchronizationStrategyName> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.synchronization_strategy").as(HibernateOrmAutomaticIndexingSynchronizationStrategyName.class, HibernateOrmAutomaticIndexingSynchronizationStrategyName::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY).build();
    private static final ConfigurationProperty<EntityLoadingCacheLookupStrategy> QUERY_LOADING_CACHE_LOOKUP_STRATEGY = ConfigurationProperty.forKey((String)"query.loading.cache_lookup_strategy").as(EntityLoadingCacheLookupStrategy.class, EntityLoadingCacheLookupStrategy::of).withDefault((Object)HibernateOrmMapperSettings.Defaults.QUERY_LOADING_CACHE_LOOKUP_STRATEGY).build();
    private static final ConfigurationProperty<Integer> QUERY_LOADING_FETCH_SIZE = ConfigurationProperty.forKey((String)"query.loading.fetch_size").asInteger().withDefault((Object)100).build();
    private static final String SEARCH_SESSION_KEY = HibernateOrmMapping.class.getName() + "#SEARCH_SESSION_KEY";
    private final HibernateOrmMappingContextImpl mappingContext;
    private final HibernateOrmTypeContextContainer typeContextContainer;
    private final AutomaticIndexingSynchronizationStrategy synchronizationStrategy;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;
    private final int fetchSize;

    public static MappingImplementor<HibernateOrmMapping> create(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, ConfigurationPropertySource propertySource) {
        AutomaticIndexingSynchronizationStrategy synchronizationStrategy;
        HibernateOrmAutomaticIndexingSynchronizationStrategyName synchronizationStrategyName = (HibernateOrmAutomaticIndexingSynchronizationStrategyName)((Object)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.get(propertySource));
        switch (synchronizationStrategyName) {
            case QUEUED: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.queued();
                break;
            }
            case COMMITTED: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.committed();
                break;
            }
            case SEARCHABLE: {
                synchronizationStrategy = AutomaticIndexingSynchronizationStrategy.searchable();
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected automatic indexing synchronization strategy name: " + (Object)((Object)synchronizationStrategyName));
            }
        }
        EntityLoadingCacheLookupStrategy cacheLookupStrategy = (EntityLoadingCacheLookupStrategy)((Object)QUERY_LOADING_CACHE_LOOKUP_STRATEGY.get(propertySource));
        int fetchSize = (Integer)QUERY_LOADING_FETCH_SIZE.get(propertySource);
        return new HibernateOrmMapping(mappingDelegate, typeContextContainer, sessionFactory, synchronizationStrategy, cacheLookupStrategy, fetchSize);
    }

    private HibernateOrmMapping(PojoMappingDelegate mappingDelegate, HibernateOrmTypeContextContainer typeContextContainer, SessionFactoryImplementor sessionFactory, AutomaticIndexingSynchronizationStrategy synchronizationStrategy, EntityLoadingCacheLookupStrategy cacheLookupStrategy, int fetchSize) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.mappingContext = new HibernateOrmMappingContextImpl(sessionFactory);
        this.synchronizationStrategy = synchronizationStrategy;
        this.cacheLookupStrategy = cacheLookupStrategy;
        this.fetchSize = fetchSize;
    }

    public HibernateOrmMapping toConcreteType() {
        return this;
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor(SessionImplementor sessionImplementor, DocumentCommitStrategy commitStrategy) {
        return this.getSearchSession(sessionImplementor).createSessionWorkExecutor(commitStrategy);
    }

    @Override
    public EntityLoadingCacheLookupStrategy getCacheLookupStrategy() {
        return this.cacheLookupStrategy;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    HibernateOrmSearchSession getSearchSession(SessionImplementor sessionImplementor) {
        HibernateOrmSearchSession searchSession;
        TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
        HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
        if (searchSession == null) {
            searchSession = this.createSessionBuilder((EntityManager)sessionImplementor).build();
            reference = new TransientReference((Object)searchSession);
            sessionImplementor.setProperty(SEARCH_SESSION_KEY, (Object)reference);
            sessionImplementor.getEventListenerManager().addListener(new SessionEventListener[]{new SearchSessionClosingListener(sessionImplementor)});
        }
        return searchSession;
    }

    <E> AbstractHibernateOrmTypeContext<E> getTypeContext(Class<E> type) {
        return this.typeContextContainer.getByExactClass((Class)type);
    }

    private HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder createSessionBuilder(EntityManager entityManager) {
        SessionImplementor sessionImplementor;
        try {
            sessionImplementor = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionAccessError(e);
        }
        SessionFactory expectedSessionFactory = this.mappingContext.getSessionFactory();
        SessionFactoryImplementor givenSessionFactory = sessionImplementor.getSessionFactory();
        if (!givenSessionFactory.equals(expectedSessionFactory)) {
            throw log.usingDifferentSessionFactories(expectedSessionFactory, (SessionFactory)givenSessionFactory);
        }
        return new HibernateOrmSearchSession.HibernateOrmSearchSessionBuilder(this.getDelegate(), this.mappingContext, this, this.typeContextContainer, sessionImplementor, this.synchronizationStrategy);
    }

    private static class SearchSessionClosingListener
    extends BaseSessionEventListener {
        private final SessionImplementor sessionImplementor;

        private SearchSessionClosingListener(SessionImplementor sessionImplementor) {
            this.sessionImplementor = sessionImplementor;
        }

        public void end() {
            HibernateOrmSearchSession searchSession;
            TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
            HibernateOrmSearchSession hibernateOrmSearchSession = searchSession = reference == null ? null : (HibernateOrmSearchSession)reference.get();
            if (searchSession != null) {
                searchSession.close();
            }
        }
    }
}

