/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.mapper.orm.bootstrap.impl.ExtendedBeanManagerSynchronizer;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmBeanContainerBeanProvider;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmClassLoaderServiceClassAndResourceResolver;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateOrmIntegrationBooter;
import org.hibernate.search.mapper.orm.cfg.impl.ConsumedPropertyKeysReport;
import org.hibernate.search.mapper.orm.cfg.impl.HibernateOrmConfigurationPropertySource;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingInitiator;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMappingKey;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateSearchContextService;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class HibernateOrmIntegrationBooterImpl
implements HibernateOrmIntegrationBooter {
    private static final OptionalConfigurationProperty<HibernateOrmIntegrationPartialBuildState> INTEGRATION_PARTIAL_BUILD_STATE = ConfigurationProperty.forKey((String)"integration_partial_build_state").as(HibernateOrmIntegrationPartialBuildState.class, HibernateOrmIntegrationPartialBuildState::parse).build();
    private final Metadata metadata;
    private final ServiceRegistryImplementor serviceRegistry;
    private final ReflectionManager reflectionManager;
    private final Optional<EnvironmentSynchronizer> environmentSynchronizer;
    private final HibernateOrmConfigurationPropertySource propertySource;

    public HibernateOrmIntegrationBooterImpl(Metadata metadata, BootstrapContext bootstrapContext) {
        this.metadata = metadata;
        this.serviceRegistry = (ServiceRegistryImplementor)bootstrapContext.getServiceRegistry();
        this.reflectionManager = bootstrapContext.getReflectionManager();
        ConfigurationService configurationService = (ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class);
        this.propertySource = new HibernateOrmConfigurationPropertySource(configurationService);
        Optional<EnvironmentSynchronizer> providedEnvironmentSynchronizer = this.getOrmServiceOrEmpty(EnvironmentSynchronizer.class);
        if (providedEnvironmentSynchronizer.isPresent()) {
            this.environmentSynchronizer = providedEnvironmentSynchronizer;
        } else {
            Object unknownBeanManager = configurationService.getSettings().get("javax.persistence.bean.manager");
            if (unknownBeanManager instanceof ExtendedBeanManager) {
                ExtendedBeanManager extendedBeanManager = (ExtendedBeanManager)unknownBeanManager;
                ExtendedBeanManagerSynchronizer synchronizer = new ExtendedBeanManagerSynchronizer();
                extendedBeanManager.registerLifecycleListener((ExtendedBeanManager.LifecycleListener)synchronizer);
                this.environmentSynchronizer = Optional.of(synchronizer);
            } else {
                this.environmentSynchronizer = Optional.empty();
            }
        }
    }

    @Override
    public void preBoot(BiConsumer<String, Object> propertyCollector) {
        if (this.environmentSynchronizer.isPresent()) {
            throw new AssertionFailure("Cannot pre-boot when an environment synchronizer is used to delay Hibernate Search's bootstrap:  we cannot both delay bootstrap and perform it earlier.");
        }
        HibernateOrmIntegrationPartialBuildState partialBuildState = this.doBootFirstPhase();
        propertyCollector.accept("hibernate.search.integration_partial_build_state", partialBuildState);
    }

    CompletableFuture<HibernateSearchContextService> orchestrateBootAndShutdown(CompletionStage<SessionFactoryImplementor> sessionFactoryReadyStage, CompletionStage<?> sessionFactoryDestroyingStage) {
        CompletableFuture environmentSynchronizerReadyStage = new CompletableFuture();
        CompletableFuture environmentSynchronizerStartedDestroyingStage = new CompletableFuture();
        if (this.environmentSynchronizer.isPresent()) {
            this.environmentSynchronizer.get().whenEnvironmentDestroying(() -> environmentSynchronizerReadyStage.complete(null));
            this.environmentSynchronizer.get().whenEnvironmentReady(() -> environmentSynchronizerStartedDestroyingStage.complete(null));
        } else {
            environmentSynchronizerReadyStage.complete(null);
        }
        CompletionStage bootRequiredStage = environmentSynchronizerReadyStage.thenCombine(sessionFactoryReadyStage, (ignored, sessionFactory) -> sessionFactory);
        CompletableFuture<Object> shutdownRequiredStage = CompletableFuture.anyOf(environmentSynchronizerStartedDestroyingStage, sessionFactoryDestroyingStage.toCompletableFuture());
        CompletionStage contextBootedFuture = ((CompletableFuture)bootRequiredStage).thenApply(this::bootNow);
        shutdownRequiredStage.thenRun(() -> HibernateOrmIntegrationBooterImpl.lambda$orchestrateBootAndShutdown$3((CompletableFuture)bootRequiredStage));
        shutdownRequiredStage.thenAcceptBoth(contextBootedFuture, (ignored, context) -> context.close());
        return contextBootedFuture;
    }

    private HibernateSearchContextService bootNow(SessionFactoryImplementor sessionFactoryImplementor) {
        Optional partialBuildStateOptional = (Optional)INTEGRATION_PARTIAL_BUILD_STATE.get((ConfigurationPropertySource)this.propertySource);
        HibernateOrmIntegrationPartialBuildState partialBuildState = partialBuildStateOptional.isPresent() ? (HibernateOrmIntegrationPartialBuildState)partialBuildStateOptional.get() : this.doBootFirstPhase();
        try {
            return this.doBootSecondPhase(partialBuildState, sessionFactoryImplementor);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(HibernateOrmIntegrationPartialBuildState::closeOnFailure, (Object)partialBuildState);
            throw e;
        }
    }

    private HibernateOrmIntegrationPartialBuildState doBootFirstPhase() {
        ReflectionBeanProvider reflectionBeanProvider = null;
        Object beanProvider = null;
        SearchIntegrationPartialBuildState searchIntegrationPartialBuildState = null;
        try {
            BeanContainer beanContainer;
            this.propertySource.beforeBoot();
            SearchIntegrationBuilder builder = SearchIntegration.builder((ConfigurationPropertySource)this.propertySource);
            HibernateOrmMappingKey mappingKey = new HibernateOrmMappingKey();
            HibernateOrmMappingInitiator mappingInitiator = HibernateOrmMappingInitiator.create(this.metadata, this.reflectionManager, this.propertySource);
            builder.addMappingInitiator((MappingKey)mappingKey, (MappingInitiator)mappingInitiator);
            ClassLoaderService hibernateOrmClassLoaderService = this.getOrmServiceOrFail(ClassLoaderService.class);
            Optional<ManagedBeanRegistry> managedBeanRegistryService = this.getOrmServiceOrEmpty(ManagedBeanRegistry.class);
            HibernateOrmClassLoaderServiceClassAndResourceResolver classAndResourceResolver = new HibernateOrmClassLoaderServiceClassAndResourceResolver(hibernateOrmClassLoaderService);
            builder.setClassResolver((ClassResolver)classAndResourceResolver);
            builder.setResourceResolver((ResourceResolver)classAndResourceResolver);
            reflectionBeanProvider = new ReflectionBeanProvider((ClassResolver)classAndResourceResolver);
            if (managedBeanRegistryService.isPresent() && (beanContainer = managedBeanRegistryService.get().getBeanContainer()) != null) {
                beanProvider = new HibernateOrmBeanContainerBeanProvider(beanContainer, reflectionBeanProvider);
            }
            if (beanProvider == null) {
                beanProvider = reflectionBeanProvider;
            }
            builder.setBeanProvider((BeanProvider)beanProvider);
            searchIntegrationPartialBuildState = builder.prepareBuild();
            return new HibernateOrmIntegrationPartialBuildState(searchIntegrationPartialBuildState, mappingKey, this.propertySource.getConsumedPropertiesReport());
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser((Throwable)e).push(SearchIntegrationPartialBuildState::closeOnFailure, searchIntegrationPartialBuildState)).push(BeanProvider::close, reflectionBeanProvider)).push(BeanProvider::close, beanProvider);
            throw e;
        }
    }

    private HibernateSearchContextService doBootSecondPhase(HibernateOrmIntegrationPartialBuildState partialBuildState, SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateOrmMapping mapping = (HibernateOrmMapping)partialBuildState.integrationBuildState.finalizeMapping((MappingKey)partialBuildState.mappingKey, mappingPartialBuildState -> mappingPartialBuildState.bindToSessionFactory(sessionFactoryImplementor, this.propertySource));
        SearchIntegration integration = partialBuildState.integrationBuildState.finalizeIntegration((ConfigurationPropertySource)this.propertySource);
        HibernateSearchContextService contextService = (HibernateSearchContextService)sessionFactoryImplementor.getServiceRegistry().getService(HibernateSearchContextService.class);
        contextService.initialize(integration, mapping);
        this.propertySource.afterBoot(partialBuildState.bootFirstPhaseConsumedPropertyKeysReport);
        return contextService;
    }

    private <T extends Service> T getOrmServiceOrFail(Class<T> serviceClass) {
        Service service = this.serviceRegistry.getService(serviceClass);
        if (service == null) {
            throw new AssertionFailure("A required service was missing; there is probably a bug in Hibernate ORM or Hibernate Search. Missing service: " + serviceClass);
        }
        return (T)service;
    }

    private <T extends Service> Optional<T> getOrmServiceOrEmpty(Class<T> serviceClass) {
        ServiceBinding binding = this.serviceRegistry.locateServiceBinding(serviceClass);
        if (binding == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.serviceRegistry.getService(serviceClass));
    }

    private static /* synthetic */ void lambda$orchestrateBootAndShutdown$3(CompletableFuture bootRequiredStage) {
        bootRequiredStage.cancel(false);
    }

    private static final class HibernateOrmIntegrationPartialBuildState {
        private final SearchIntegrationPartialBuildState integrationBuildState;
        private final HibernateOrmMappingKey mappingKey;
        private final Optional<ConsumedPropertyKeysReport> bootFirstPhaseConsumedPropertyKeysReport;

        static HibernateOrmIntegrationPartialBuildState parse(String stringToParse) {
            throw new AssertionFailure("The partial build state cannot be parsed from a String; it must be null or an instance of " + HibernateOrmIntegrationPartialBuildState.class);
        }

        HibernateOrmIntegrationPartialBuildState(SearchIntegrationPartialBuildState integrationBuildState, HibernateOrmMappingKey mappingKey, Optional<ConsumedPropertyKeysReport> bootFirstPhaseConsumedPropertyKeysReport) {
            this.integrationBuildState = integrationBuildState;
            this.mappingKey = mappingKey;
            this.bootFirstPhaseConsumedPropertyKeysReport = bootFirstPhaseConsumedPropertyKeysReport;
        }

        void closeOnFailure() {
            this.integrationBuildState.closeOnFailure();
        }
    }
}

