/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HibernateOrmByTypeEntityLoader<E, T>
implements EntityLoader<EntityReference, T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<Class<? extends E>, HibernateOrmComposableEntityLoader<EntityReference, ? extends T>> delegatesByConcreteType;

    HibernateOrmByTypeEntityLoader(Map<Class<? extends E>, HibernateOrmComposableEntityLoader<EntityReference, ? extends T>> delegatesByConcreteType) {
        this.delegatesByConcreteType = delegatesByConcreteType;
    }

    public List<T> loadBlocking(List<EntityReference> references) {
        HibernateOrmComposableEntityLoader delegate;
        LinkedHashMap objectsByReference = new LinkedHashMap(references.size());
        HashMap<HibernateOrmComposableEntityLoader, List> referencesByDelegate = new HashMap<HibernateOrmComposableEntityLoader, List>();
        for (EntityReference entityReference : references) {
            objectsByReference.put(entityReference, null);
            delegate = this.getDelegate(entityReference.getType());
            referencesByDelegate.computeIfAbsent(delegate, ignored -> new ArrayList()).add(entityReference);
        }
        for (Map.Entry entry : referencesByDelegate.entrySet()) {
            delegate = (HibernateOrmComposableEntityLoader)entry.getKey();
            List referencesForDelegate = (List)entry.getValue();
            delegate.loadBlocking(referencesForDelegate, objectsByReference);
        }
        ArrayList result = new ArrayList(references.size());
        for (EntityReference reference : references) {
            result.add(objectsByReference.get(reference));
        }
        return result;
    }

    private HibernateOrmComposableEntityLoader<EntityReference, ? extends T> getDelegate(Class<?> entityType) {
        HibernateOrmComposableEntityLoader<EntityReference, ? extends T> delegate = this.delegatesByConcreteType.get(entityType);
        if (delegate == null) {
            throw log.unexpectedSearchHitType(entityType, this.delegatesByConcreteType.keySet());
        }
        return delegate;
    }
}

