/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.HashMap;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmByTypeEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;

public class EntityLoaderBuilder<E> {
    private final Session session;
    private final Set<? extends HibernateOrmLoadingIndexedTypeContext<? extends E>> concreteIndexedTypes;

    public EntityLoaderBuilder(Session session, Set<? extends HibernateOrmLoadingIndexedTypeContext<? extends E>> concreteIndexedTypes) {
        this.session = session;
        this.concreteIndexedTypes = concreteIndexedTypes;
    }

    public EntityLoader<EntityReference, ? extends E> build(MutableEntityLoadingOptions mutableLoadingOptions) {
        if (this.concreteIndexedTypes.size() == 1) {
            HibernateOrmLoadingIndexedTypeContext<E> typeContext = this.concreteIndexedTypes.iterator().next();
            return typeContext.createLoader(this.session, mutableLoadingOptions);
        }
        return this.buildForMultipleTypes(mutableLoadingOptions);
    }

    private EntityLoader<EntityReference, E> buildForMultipleTypes(MutableEntityLoadingOptions mutableLoadingOptions) {
        HashMap delegateByConcreteType = new HashMap(this.concreteIndexedTypes.size());
        for (HibernateOrmLoadingIndexedTypeContext<E> typeContext : this.concreteIndexedTypes) {
            HibernateOrmComposableEntityLoader<EntityReference, ? extends E> delegate = typeContext.createLoader(this.session, mutableLoadingOptions);
            delegateByConcreteType.put(typeContext.getJavaClass(), delegate);
        }
        return new HibernateOrmByTypeEntityLoader(delegateByConcreteType);
    }
}

