/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicPropertyMetadata;

class HibernateOrmBasicTypeMetadata {
    private final Class<?> javaClass;
    private final Map<String, Property> properties;
    private final Property identifierProperty;

    public static HibernateOrmBasicTypeMetadata create(PersistentClass persistentClass) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        HibernateOrmBasicTypeMetadata.collectProperties(properties, persistentClass.getPropertyIterator());
        Property identifierProperty = persistentClass.getIdentifierProperty();
        if (identifierProperty != null) {
            properties.put(identifierProperty.getName(), identifierProperty);
        }
        return new HibernateOrmBasicTypeMetadata(persistentClass.getMappedClass(), properties, identifierProperty);
    }

    public static HibernateOrmBasicTypeMetadata create(Component component) {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        HibernateOrmBasicTypeMetadata.collectProperties(properties, component.getPropertyIterator());
        return new HibernateOrmBasicTypeMetadata(component.getComponentClass(), properties, null);
    }

    private static void collectProperties(Map<String, Property> collected, Iterator<Property> propertyIterator) {
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            collected.put(property.getName(), property);
        }
    }

    private HibernateOrmBasicTypeMetadata(Class<?> javaClass, Map<String, Property> properties, Property identifierProperty) {
        this.javaClass = javaClass;
        this.properties = properties;
        this.identifierProperty = identifierProperty;
    }

    HibernateOrmBasicPropertyMetadata getPropertyMetadataOrNull(String propertyName) {
        try {
            Property property = this.properties.get(propertyName);
            if (property == null) {
                return null;
            }
            Getter getter = property.getGetter(this.javaClass);
            boolean isId = property.equals(this.identifierProperty);
            return new HibernateOrmBasicPropertyMetadata(getter.getMember(), isId);
        }
        catch (MappingException e) {
            return null;
        }
    }
}

