/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.IdentifierProducer;
import org.hibernate.search.mapper.orm.massindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.monitor.MassIndexingMonitor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Executors;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace
extends ErrorHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionFactoryImplementor sessionFactory;
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final DetachedSessionContextImplementor sessionContext;
    private final ProducerConsumerQueue<List<Serializable>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<?> indexedType;
    private final String idNameOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexingMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final long objectsLimit;
    private final int idFetchSize;
    private final Integer transactionTimeout;
    private final List<Future<?>> tasks = new ArrayList();

    BatchIndexingWorkspace(SessionFactoryImplementor sessionFactory, HibernateOrmMassIndexingMappingContext mappingContext, DetachedSessionContextImplementor sessionContext, Class<?> type, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexingMonitor monitor, long objectsLimit, int idFetchSize, Integer transactionTimeout) {
        this.sessionFactory = sessionFactory;
        this.mappingContext = mappingContext;
        this.sessionContext = sessionContext;
        this.indexedType = type;
        this.idFetchSize = idFetchSize;
        this.transactionTimeout = transactionTimeout;
        this.idNameOfIndexedType = sessionFactory.getMetamodel().entity(this.indexedType).locateIdAttribute().getName();
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.documentBuilderThreads);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (!this.tasks.isEmpty()) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused - tasks should be empty");
        }
        try {
            BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.sessionFactory);
            this.startTransformationToLuceneWork();
            this.startProducingPrimaryKeys(transactionalContext);
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", this.indexedType.getName());
            }
            catch (InterruptedException e) {
                for (Future<?> task : this.tasks) {
                    if (task.isDone()) continue;
                    task.cancel(true);
                }
                Thread.currentThread().interrupt();
                throw log.interruptedBatchIndexingException(e);
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierProducer(this.primaryKeyStream, (SessionFactory)this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit, this.idFetchSize, this.sessionContext.getTenantIdentifier()), this.transactionTimeout, this.sessionContext.getTenantIdentifier());
        ThreadPoolExecutor execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        try {
            this.tasks.add(execIdentifiersLoader.submit(primaryKeyOutputter));
        }
        finally {
            execIdentifiersLoader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransformationToLuceneWork() {
        IdentifierConsumerDocumentProducer documentOutputter = new IdentifierConsumerDocumentProducer(this.primaryKeyStream, this.monitor, (SessionFactory)this.sessionFactory, this.mappingContext, this.producerEndSignal, this.cacheMode, this.indexedType, this.idNameOfIndexedType, this.transactionTimeout, this.sessionContext.getTenantIdentifier());
        ThreadPoolExecutor execFirstLoader = Executors.newFixedThreadPool((int)this.documentBuilderThreads, (String)"entityloader");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                this.tasks.add(execFirstLoader.submit(documentOutputter));
            }
        }
        finally {
            execFirstLoader.shutdown();
        }
    }
}

