/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmComposableEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmSingleTypeByIdEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmSingleTypeCriteriaEntityLoader;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionIndexedTypeContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.spi.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;

class HibernateOrmIndexedTypeContext<E>
extends AbstractHibernateOrmTypeContext<E>
implements HibernateOrmSessionIndexedTypeContext<E>,
HibernateOrmScopeIndexedTypeContext<E> {
    private final String indexName;
    private final SingularAttribute<? super E, ?> nonIdDocumentIdSourceProperty;
    private final IdentifierMapping identifierMapping;

    private HibernateOrmIndexedTypeContext(Builder<E> builder, SessionFactory sessionFactory) {
        super(((Builder)builder).javaClass);
        this.indexName = ((Builder)builder).indexName;
        EntityType indexTypeModel = sessionFactory.getMetamodel().entity(this.getJavaClass());
        SingularAttribute documentIdSourceProperty = indexTypeModel.getSingularAttribute(((Builder)builder).documentIdSourcePropertyName);
        this.nonIdDocumentIdSourceProperty = documentIdSourceProperty.isId() ? null : documentIdSourceProperty;
        this.identifierMapping = ((Builder)builder).identifierMapping;
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Object toWorkPlanProvidedId(Object entityId) {
        if (this.nonIdDocumentIdSourceProperty != null) {
            return null;
        }
        return entityId;
    }

    @Override
    public IdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public HibernateOrmComposableEntityLoader<EntityReference, E> createLoader(Session session, MutableEntityLoadingOptions mutableLoadingOptions) {
        if (this.nonIdDocumentIdSourceProperty != null) {
            return new HibernateOrmSingleTypeCriteriaEntityLoader<E>(session, this.getJavaClass(), this.nonIdDocumentIdSourceProperty, mutableLoadingOptions);
        }
        return new HibernateOrmSingleTypeByIdEntityLoader(session, this.getJavaClass(), mutableLoadingOptions);
    }

    static class Builder<E>
    implements PojoIndexedTypeExtendedMappingCollector {
        private final Class<E> javaClass;
        private final String indexName;
        private String documentIdSourcePropertyName;
        private IdentifierMapping identifierMapping;

        Builder(Class<E> javaClass, String indexName) {
            this.javaClass = javaClass;
            this.indexName = indexName;
        }

        public void documentIdSourcePropertyName(String documentIdSourcePropertyName) {
            this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        }

        public void identifierMapping(IdentifierMapping identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        public HibernateOrmIndexedTypeContext<E> build(SessionFactory sessionFactory) {
            return new HibernateOrmIndexedTypeContext(this, sessionFactory);
        }
    }
}

